package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  CustomerOwnedIpv4Pool,
  SecurityGroupId,
  SubnetId,
  LoadBalancerName
}
import scala.jdk.CollectionConverters.*
final case class CreateLoadBalancerRequest(
    name: LoadBalancerName,
    subnets: Optional[Iterable[SubnetId]] = Optional.Absent,
    subnetMappings: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.SubnetMapping]
    ] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    scheme: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Tag]] =
      Optional.Absent,
    `type`: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = Optional.Absent,
    ipAddressType: Optional[
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest = {
    import CreateLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
      .builder()
      .name(LoadBalancerName.unwrap(name): java.lang.String)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(scheme.map(value => value.unwrap))(_.scheme)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CustomerOwnedIpv4Pool.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest =
      zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest(
        name,
        subnets.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroups.map(value => value),
        scheme.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        ipAddressType.map(value => value),
        customerOwnedIpv4Pool.map(value => value)
      )
    def name: LoadBalancerName
    def subnets: Optional[List[SubnetId]]
    def subnetMappings: Optional[
      List[zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly]
    ]
    def securityGroups: Optional[List[SecurityGroupId]]
    def scheme
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum]
    def tags: Optional[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]]
    def `type`
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum]
    def ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool]
    def getName: ZIO[Any, Nothing, LoadBalancerName] = ZIO.succeed(name)
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getScheme: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = AwsError.unwrapOptionField("scheme", scheme)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = AwsError.unwrapOptionField("type", `type`)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CustomerOwnedIpv4Pool] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest.ReadOnly {
    override val name: LoadBalancerName =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerName(impl.name())
    override val subnets: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.SubnetId(item)
        }.toList
      )
    override val subnetMappings: Optional[
      List[zio.aws.elasticloadbalancingv2.model.SubnetMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.SubnetMapping.wrap(item)
        }.toList
      )
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .SecurityGroupId(item)
          }.toList
        )
    override val scheme: Optional[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheme())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum.wrap(value)
      )
    override val tags
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
          }.toList
        )
    override val `type`
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum.wrap(value)
        )
    override val ipAddressType
        : Optional[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
        )
    override val customerOwnedIpv4Pool: Optional[CustomerOwnedIpv4Pool] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOwnedIpv4Pool())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .CustomerOwnedIpv4Pool(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
  ): zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
