package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{RulePriority, RuleArn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RulePriorityPair(
    ruleArn: Optional[RuleArn] = Optional.Absent,
    priority: Optional[RulePriority] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair = {
    import RulePriorityPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
      .builder()
      .optionallyWith(
        ruleArn.map(value => RuleArn.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(
        priority.map(value => RulePriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RulePriorityPair.wrap(buildAwsValue())
}
object RulePriorityPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.RulePriorityPair =
      zio.aws.elasticloadbalancingv2.model.RulePriorityPair(
        ruleArn.map(value => value),
        priority.map(value => value)
      )
    def ruleArn: Optional[RuleArn]
    def priority: Optional[RulePriority]
    def getRuleArn: ZIO[Any, AwsError, RuleArn] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getPriority: ZIO[Any, AwsError, RulePriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ) extends zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly {
    override val ruleArn: Optional[RuleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(value)
      )
    override val priority: Optional[RulePriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.RulePriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair
  ): zio.aws.elasticloadbalancingv2.model.RulePriorityPair.ReadOnly =
    new Wrapper(impl)
}
