package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  TargetGroupAttributeValue,
  TargetGroupAttributeKey
}
import scala.jdk.CollectionConverters.*
final case class TargetGroupAttribute(
    key: Optional[TargetGroupAttributeKey] = Optional.Absent,
    value: Optional[TargetGroupAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute = {
    import TargetGroupAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute
      .builder()
      .optionallyWith(
        key.map(value =>
          TargetGroupAttributeKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        value.map(value =>
          TargetGroupAttributeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute
      .wrap(buildAwsValue())
}
object TargetGroupAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute =
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[TargetGroupAttributeKey]
    def value: Optional[TargetGroupAttributeValue]
    def getKey: ZIO[Any, AwsError, TargetGroupAttributeKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TargetGroupAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute
  ) extends zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly {
    override val key: Optional[TargetGroupAttributeKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .TargetGroupAttributeKey(value)
      )
    override val value: Optional[TargetGroupAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .TargetGroupAttributeValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute
  ): zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly =
    new Wrapper(impl)
}
