package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn
import scala.jdk.CollectionConverters.*
final case class DescribeLoadBalancerAttributesRequest(
    loadBalancerArn: LoadBalancerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest = {
    import DescribeLoadBalancerAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest =
      zio.aws.elasticloadbalancingv2.model
        .DescribeLoadBalancerAttributesRequest(loadBalancerArn)
    def loadBalancerArn: LoadBalancerArn
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
