package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTargetGroupResponse(
    targetGroups: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse = {
    import CreateTargetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse
      .wrap(buildAwsValue())
}
object CreateTargetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse =
      zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
  ) extends zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly {
    override val targetGroups: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
  ): zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
