package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.StringValue
import scala.jdk.CollectionConverters.*
final case class SourceIpConditionConfig(
    values: Optional[Iterable[StringValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig = {
    import SourceIpConditionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig
      .builder()
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig
      .wrap(buildAwsValue())
}
object SourceIpConditionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig =
      zio.aws.elasticloadbalancingv2.model
        .SourceIpConditionConfig(values.map(value => value))
    def values: Optional[List[StringValue]]
    def getValues: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly {
    override val values: Optional[List[StringValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SourceIpConditionConfig
  ): zio.aws.elasticloadbalancingv2.model.SourceIpConditionConfig.ReadOnly =
    new Wrapper(impl)
}
