package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn
import scala.jdk.CollectionConverters.*
final case class DeleteLoadBalancerRequest(loadBalancerArn: LoadBalancerArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest = {
    import DeleteLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerRequest =
      zio.aws.elasticloadbalancingv2.model
        .DeleteLoadBalancerRequest(loadBalancerArn)
    def loadBalancerArn: LoadBalancerArn
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
  ): zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
