package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRuleResponse(
    rules: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Rule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateRuleResponse
      .wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.CreateRuleResponse =
      zio.aws.elasticloadbalancingv2.model.CreateRuleResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse
  ) extends zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Rule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse
  ): zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly =
    new Wrapper(impl)
}
