package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  AuthenticateCognitoActionAuthenticationRequestParamName,
  AuthenticateCognitoActionUserPoolArn,
  AuthenticateCognitoActionSessionCookieName,
  AuthenticateCognitoActionUserPoolDomain,
  AuthenticateCognitoActionSessionTimeout,
  AuthenticateCognitoActionAuthenticationRequestParamValue,
  AuthenticateCognitoActionUserPoolClientId,
  AuthenticateCognitoActionScope
}
import scala.jdk.CollectionConverters.*
final case class AuthenticateCognitoActionConfig(
    userPoolArn: AuthenticateCognitoActionUserPoolArn,
    userPoolClientId: AuthenticateCognitoActionUserPoolClientId,
    userPoolDomain: AuthenticateCognitoActionUserPoolDomain,
    sessionCookieName: Optional[AuthenticateCognitoActionSessionCookieName] =
      Optional.Absent,
    scope: Optional[AuthenticateCognitoActionScope] = Optional.Absent,
    sessionTimeout: Optional[AuthenticateCognitoActionSessionTimeout] =
      Optional.Absent,
    authenticationRequestExtraParams: Optional[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = Optional.Absent,
    onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig = {
    import AuthenticateCognitoActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
      .builder()
      .userPoolArn(
        AuthenticateCognitoActionUserPoolArn.unwrap(
          userPoolArn
        ): java.lang.String
      )
      .userPoolClientId(
        AuthenticateCognitoActionUserPoolClientId.unwrap(
          userPoolClientId
        ): java.lang.String
      )
      .userPoolDomain(
        AuthenticateCognitoActionUserPoolDomain.unwrap(
          userPoolDomain
        ): java.lang.String
      )
      .optionallyWith(
        sessionCookieName.map(value =>
          AuthenticateCognitoActionSessionCookieName.unwrap(
            value
          ): java.lang.String
        )
      )(_.sessionCookieName)
      .optionallyWith(
        scope.map(value =>
          AuthenticateCognitoActionScope.unwrap(value): java.lang.String
        )
      )(_.scope)
      .optionallyWith(
        sessionTimeout.map(value =>
          AuthenticateCognitoActionSessionTimeout.unwrap(value): java.lang.Long
        )
      )(_.sessionTimeout)
      .optionallyWith(
        authenticationRequestExtraParams.map(value =>
          value
            .map({ case (key, value) =>
              (AuthenticateCognitoActionAuthenticationRequestParamName.unwrap(
                key
              ): java.lang.String) -> (AuthenticateCognitoActionAuthenticationRequestParamValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.authenticationRequestExtraParams)
      .optionallyWith(onUnauthenticatedRequest.map(value => value.unwrap))(
        _.onUnauthenticatedRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
      .wrap(buildAwsValue())
}
object AuthenticateCognitoActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig =
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig(
        userPoolArn,
        userPoolClientId,
        userPoolDomain,
        sessionCookieName.map(value => value),
        scope.map(value => value),
        sessionTimeout.map(value => value),
        authenticationRequestExtraParams.map(value => value),
        onUnauthenticatedRequest.map(value => value)
      )
    def userPoolArn: AuthenticateCognitoActionUserPoolArn
    def userPoolClientId: AuthenticateCognitoActionUserPoolClientId
    def userPoolDomain: AuthenticateCognitoActionUserPoolDomain
    def sessionCookieName: Optional[AuthenticateCognitoActionSessionCookieName]
    def scope: Optional[AuthenticateCognitoActionScope]
    def sessionTimeout: Optional[AuthenticateCognitoActionSessionTimeout]
    def authenticationRequestExtraParams: Optional[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]]
    def onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ]
    def getUserPoolArn
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolArn] =
      ZIO.succeed(userPoolArn)
    def getUserPoolClientId
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolClientId] =
      ZIO.succeed(userPoolClientId)
    def getUserPoolDomain
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolDomain] =
      ZIO.succeed(userPoolDomain)
    def getSessionCookieName
        : ZIO[Any, AwsError, AuthenticateCognitoActionSessionCookieName] =
      AwsError.unwrapOptionField("sessionCookieName", sessionCookieName)
    def getScope: ZIO[Any, AwsError, AuthenticateCognitoActionScope] =
      AwsError.unwrapOptionField("scope", scope)
    def getSessionTimeout
        : ZIO[Any, AwsError, AuthenticateCognitoActionSessionTimeout] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
    def getAuthenticationRequestExtraParams: ZIO[Any, AwsError, Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = AwsError.unwrapOptionField(
      "authenticationRequestExtraParams",
      authenticationRequestExtraParams
    )
    def getOnUnauthenticatedRequest: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = AwsError.unwrapOptionField(
      "onUnauthenticatedRequest",
      onUnauthenticatedRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly {
    override val userPoolArn: AuthenticateCognitoActionUserPoolArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolArn(impl.userPoolArn())
    override val userPoolClientId: AuthenticateCognitoActionUserPoolClientId =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolClientId(impl.userPoolClientId())
    override val userPoolDomain: AuthenticateCognitoActionUserPoolDomain =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolDomain(impl.userPoolDomain())
    override val sessionCookieName
        : Optional[AuthenticateCognitoActionSessionCookieName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionCookieName())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateCognitoActionSessionCookieName(value)
        )
    override val scope: Optional[AuthenticateCognitoActionScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateCognitoActionScope(value)
        )
    override val sessionTimeout
        : Optional[AuthenticateCognitoActionSessionTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionTimeout())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .AuthenticateCognitoActionSessionTimeout(value)
        )
    override val authenticationRequestExtraParams: Optional[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationRequestExtraParams())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateCognitoActionAuthenticationRequestParamName(
                key
              ) -> zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateCognitoActionAuthenticationRequestParamValue(value)
          })
          .toMap
      )
    override val onUnauthenticatedRequest: Optional[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.onUnauthenticatedRequest())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ): zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly =
    new Wrapper(impl)
}
