package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters.*
sealed trait IpAddressType {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType
}
object IpAddressType {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType
  ): zio.aws.elasticloadbalancingv2.model.IpAddressType = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.DUALSTACK =>
      val r = dualstack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.elasticloadbalancingv2.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.IPV4
  }
  case object dualstack
      extends zio.aws.elasticloadbalancingv2.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType.DUALSTACK
  }
}
