package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn
import scala.jdk.CollectionConverters.*
final case class RemoveListenerCertificatesRequest(
    listenerArn: ListenerArn,
    certificates: Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest = {
    import RemoveListenerCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
      .builder()
      .listenerArn(ListenerArn.unwrap(listenerArn): java.lang.String)
      .certificates(certificates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
      .wrap(buildAwsValue())
}
object RemoveListenerCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest =
      zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest(
        listenerArn,
        certificates.map { item =>
          item.asEditable
        }
      )
    def listenerArn: ListenerArn
    def certificates
        : List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    def getListenerArn: ZIO[Any, Nothing, ListenerArn] =
      ZIO.succeed(listenerArn)
    def getCertificates: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = ZIO.succeed(certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest.ReadOnly {
    override val listenerArn: ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .ListenerArn(impl.listenerArn())
    override val certificates
        : List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly] = impl
      .certificates()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
  ): zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
