package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{Max, Name}
import scala.jdk.CollectionConverters.*
final case class Limit(
    name: Optional[Name] = Optional.Absent,
    max: Optional[Max] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit = {
    import Limit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(max.map(value => Max.unwrap(value): java.lang.String))(
        _.max
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Limit.wrap(buildAwsValue())
}
object Limit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Limit =
      zio.aws.elasticloadbalancingv2.model
        .Limit(name.map(value => value), max.map(value => value))
    def name: Optional[Name]
    def max: Optional[Max]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getMax: ZIO[Any, AwsError, Max] = AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit
  ) extends zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Name(value))
    override val max: Optional[Max] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Max(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit
  ): zio.aws.elasticloadbalancingv2.model.Limit.ReadOnly = new Wrapper(impl)
}
