package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.SecurityGroupId
import scala.jdk.CollectionConverters.*
final case class SetSecurityGroupsResponse(
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse = {
    import SetSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object SetSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse =
      zio.aws.elasticloadbalancingv2.model
        .SetSecurityGroupsResponse(securityGroupIds.map(value => value))
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
  ) extends zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly {
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
  ): zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
