package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn
import scala.jdk.CollectionConverters.*
final case class ModifyLoadBalancerAttributesRequest(
    loadBalancerArn: LoadBalancerArn,
    attributes: Iterable[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest = {
    import ModifyLoadBalancerAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
      .wrap(buildAwsValue())
}
object ModifyLoadBalancerAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest =
      zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest(
        loadBalancerArn,
        attributes.map { item =>
          item.asEditable
        }
      )
    def loadBalancerArn: LoadBalancerArn
    def attributes: List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly
    ]
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
    override val attributes: List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly
    ] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
  ): zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
