package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters.*
sealed trait TargetGroupIpAddressTypeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
}
object TargetGroupIpAddressTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
  ): zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum =
    value match {
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.IPV4 =>
        val r = ipv4
        r
      case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.IPV6 =>
        val r = ipv6
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4
      extends zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.IPV4
  }
  case object ipv6
      extends zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum.IPV6
  }
}
