package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddListenerCertificatesResponse(
    certificates: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse = {
    import AddListenerCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse
      .wrap(buildAwsValue())
}
object AddListenerCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse =
      zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ]
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly {
    override val certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
  ): zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
