package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  AlpnPolicyValue,
  SslPolicyName,
  Port,
  ListenerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyListenerRequest(
    listenerArn: ListenerArn,
    port: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] =
      Optional.Absent,
    sslPolicy: Optional[SslPolicyName] = Optional.Absent,
    certificates: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
    ] = Optional.Absent,
    defaultActions: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.Action]
    ] = Optional.Absent,
    alpnPolicy: Optional[Iterable[AlpnPolicyValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest = {
    import ModifyListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest
      .builder()
      .listenerArn(ListenerArn.unwrap(listenerArn): java.lang.String)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        sslPolicy.map(value => SslPolicyName.unwrap(value): java.lang.String)
      )(_.sslPolicy)
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(
        defaultActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultActions)
      .optionallyWith(
        alpnPolicy.map(value =>
          value.map { item =>
            AlpnPolicyValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alpnPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest
      .wrap(buildAwsValue())
}
object ModifyListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest =
      zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest(
        listenerArn,
        port.map(value => value),
        protocol.map(value => value),
        sslPolicy.map(value => value),
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alpnPolicy.map(value => value)
      )
    def listenerArn: ListenerArn
    def port: Optional[Port]
    def protocol: Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def sslPolicy: Optional[SslPolicyName]
    def certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ]
    def defaultActions
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]]
    def alpnPolicy: Optional[List[AlpnPolicyValue]]
    def getListenerArn: ZIO[Any, Nothing, ListenerArn] =
      ZIO.succeed(listenerArn)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getSslPolicy: ZIO[Any, AwsError, SslPolicyName] =
      AwsError.unwrapOptionField("sslPolicy", sslPolicy)
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
    def getDefaultActions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = AwsError.unwrapOptionField("defaultActions", defaultActions)
    def getAlpnPolicy: ZIO[Any, AwsError, List[AlpnPolicyValue]] =
      AwsError.unwrapOptionField("alpnPolicy", alpnPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest.ReadOnly {
    override val listenerArn: ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .ListenerArn(impl.listenerArn())
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Port(value))
    override val protocol
        : Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
        )
    override val sslPolicy: Optional[SslPolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.sslPolicy())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(value)
      )
    override val certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
        }.toList
      )
    override val defaultActions
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
          }.toList
        )
    override val alpnPolicy: Optional[List[AlpnPolicyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alpnPolicy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .AlpnPolicyValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest
  ): zio.aws.elasticloadbalancingv2.model.ModifyListenerRequest.ReadOnly =
    new Wrapper(impl)
}
