package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  AlpnPolicyValue,
  SslPolicyName,
  Port,
  LoadBalancerArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateListenerRequest(
    loadBalancerArn: LoadBalancerArn,
    protocol: Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] =
      Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    sslPolicy: Optional[SslPolicyName] = Optional.Absent,
    certificates: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
    ] = Optional.Absent,
    defaultActions: Iterable[zio.aws.elasticloadbalancingv2.model.Action],
    alpnPolicy: Optional[Iterable[AlpnPolicyValue]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticloadbalancingv2.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest = {
    import CreateListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest
      .builder()
      .loadBalancerArn(
        LoadBalancerArn.unwrap(loadBalancerArn): java.lang.String
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        sslPolicy.map(value => SslPolicyName.unwrap(value): java.lang.String)
      )(_.sslPolicy)
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .defaultActions(defaultActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        alpnPolicy.map(value =>
          value.map { item =>
            AlpnPolicyValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alpnPolicy)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateListenerRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateListenerRequest
      .wrap(buildAwsValue())
}
object CreateListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.CreateListenerRequest =
      zio.aws.elasticloadbalancingv2.model.CreateListenerRequest(
        loadBalancerArn,
        protocol.map(value => value),
        port.map(value => value),
        sslPolicy.map(value => value),
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultActions.map { item =>
          item.asEditable
        },
        alpnPolicy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerArn: LoadBalancerArn
    def protocol: Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def port: Optional[Port]
    def sslPolicy: Optional[SslPolicyName]
    def certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ]
    def defaultActions
        : List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]
    def alpnPolicy: Optional[List[AlpnPolicyValue]]
    def tags: Optional[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]]
    def getLoadBalancerArn: ZIO[Any, Nothing, LoadBalancerArn] =
      ZIO.succeed(loadBalancerArn)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getSslPolicy: ZIO[Any, AwsError, SslPolicyName] =
      AwsError.unwrapOptionField("sslPolicy", sslPolicy)
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
    def getDefaultActions: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = ZIO.succeed(defaultActions)
    def getAlpnPolicy: ZIO[Any, AwsError, List[AlpnPolicyValue]] =
      AwsError.unwrapOptionField("alpnPolicy", alpnPolicy)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest
  ) extends zio.aws.elasticloadbalancingv2.model.CreateListenerRequest.ReadOnly {
    override val loadBalancerArn: LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .LoadBalancerArn(impl.loadBalancerArn())
    override val protocol
        : Optional[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
        )
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Port(value))
    override val sslPolicy: Optional[SslPolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.sslPolicy())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(value)
      )
    override val certificates: Optional[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
        }.toList
      )
    override val defaultActions
        : List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly] = impl
      .defaultActions()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
      }
      .toList
    override val alpnPolicy: Optional[List[AlpnPolicyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alpnPolicy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .AlpnPolicyValue(item)
          }.toList
        )
    override val tags
        : Optional[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest
  ): zio.aws.elasticloadbalancingv2.model.CreateListenerRequest.ReadOnly =
    new Wrapper(impl)
}
