package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.RuleArn
import scala.jdk.CollectionConverters.*
final case class DeleteRuleRequest(ruleArn: RuleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest
      .builder()
      .ruleArn(RuleArn.unwrap(ruleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest =
      zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest(ruleArn)
    def ruleArn: RuleArn
    def getRuleArn: ZIO[Any, Nothing, RuleArn] = ZIO.succeed(ruleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest.ReadOnly {
    override val ruleArn: RuleArn =
      zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(impl.ruleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest
  ): zio.aws.elasticloadbalancingv2.model.DeleteRuleRequest.ReadOnly =
    new Wrapper(impl)
}
