package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  AuthenticateCognitoActionAuthenticationRequestParamName,
  AuthenticateCognitoActionUserPoolArn,
  AuthenticateCognitoActionSessionCookieName,
  AuthenticateCognitoActionUserPoolDomain,
  AuthenticateCognitoActionSessionTimeout,
  AuthenticateCognitoActionAuthenticationRequestParamValue,
  AuthenticateCognitoActionUserPoolClientId,
  AuthenticateCognitoActionScope
}
import scala.jdk.CollectionConverters.*
final case class AuthenticateCognitoActionConfig(
    userPoolArn: AuthenticateCognitoActionUserPoolArn,
    userPoolClientId: AuthenticateCognitoActionUserPoolClientId,
    userPoolDomain: AuthenticateCognitoActionUserPoolDomain,
    sessionCookieName: Option[AuthenticateCognitoActionSessionCookieName] =
      None,
    scope: Option[AuthenticateCognitoActionScope] = None,
    sessionTimeout: Option[AuthenticateCognitoActionSessionTimeout] = None,
    authenticationRequestExtraParams: Option[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = None,
    onUnauthenticatedRequest: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig = {
    import AuthenticateCognitoActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
      .builder()
      .userPoolArn(
        AuthenticateCognitoActionUserPoolArn.unwrap(
          userPoolArn
        ): java.lang.String
      )
      .userPoolClientId(
        AuthenticateCognitoActionUserPoolClientId.unwrap(
          userPoolClientId
        ): java.lang.String
      )
      .userPoolDomain(
        AuthenticateCognitoActionUserPoolDomain.unwrap(
          userPoolDomain
        ): java.lang.String
      )
      .optionallyWith(
        sessionCookieName.map(value =>
          AuthenticateCognitoActionSessionCookieName.unwrap(
            value
          ): java.lang.String
        )
      )(_.sessionCookieName)
      .optionallyWith(
        scope.map(value =>
          AuthenticateCognitoActionScope.unwrap(value): java.lang.String
        )
      )(_.scope)
      .optionallyWith(
        sessionTimeout.map(value =>
          AuthenticateCognitoActionSessionTimeout.unwrap(value): java.lang.Long
        )
      )(_.sessionTimeout)
      .optionallyWith(
        authenticationRequestExtraParams.map(value =>
          value
            .map({ case (key, value) =>
              (AuthenticateCognitoActionAuthenticationRequestParamName.unwrap(
                key
              ): java.lang.String) -> (AuthenticateCognitoActionAuthenticationRequestParamValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.authenticationRequestExtraParams)
      .optionallyWith(onUnauthenticatedRequest.map(value => value.unwrap))(
        _.onUnauthenticatedRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
      .wrap(buildAwsValue())
}
object AuthenticateCognitoActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig =
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig(
        userPoolArn,
        userPoolClientId,
        userPoolDomain,
        sessionCookieName.map(value => value),
        scope.map(value => value),
        sessionTimeout.map(value => value),
        authenticationRequestExtraParams.map(value => value),
        onUnauthenticatedRequest.map(value => value)
      )
    def userPoolArn: AuthenticateCognitoActionUserPoolArn
    def userPoolClientId: AuthenticateCognitoActionUserPoolClientId
    def userPoolDomain: AuthenticateCognitoActionUserPoolDomain
    def sessionCookieName: Option[AuthenticateCognitoActionSessionCookieName]
    def scope: Option[AuthenticateCognitoActionScope]
    def sessionTimeout: Option[AuthenticateCognitoActionSessionTimeout]
    def authenticationRequestExtraParams: Option[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]]
    def onUnauthenticatedRequest: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ]
    def getUserPoolArn
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolArn] =
      ZIO.succeed(userPoolArn)
    def getUserPoolClientId
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolClientId] =
      ZIO.succeed(userPoolClientId)
    def getUserPoolDomain
        : ZIO[Any, Nothing, AuthenticateCognitoActionUserPoolDomain] =
      ZIO.succeed(userPoolDomain)
    def getSessionCookieName
        : ZIO[Any, AwsError, AuthenticateCognitoActionSessionCookieName] =
      AwsError.unwrapOptionField("sessionCookieName", sessionCookieName)
    def getScope: ZIO[Any, AwsError, AuthenticateCognitoActionScope] =
      AwsError.unwrapOptionField("scope", scope)
    def getSessionTimeout
        : ZIO[Any, AwsError, AuthenticateCognitoActionSessionTimeout] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
    def getAuthenticationRequestExtraParams: ZIO[Any, AwsError, Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = AwsError.unwrapOptionField(
      "authenticationRequestExtraParams",
      authenticationRequestExtraParams
    )
    def getOnUnauthenticatedRequest: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = AwsError.unwrapOptionField(
      "onUnauthenticatedRequest",
      onUnauthenticatedRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly {
    override val userPoolArn: AuthenticateCognitoActionUserPoolArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolArn(impl.userPoolArn())
    override val userPoolClientId: AuthenticateCognitoActionUserPoolClientId =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolClientId(impl.userPoolClientId())
    override val userPoolDomain: AuthenticateCognitoActionUserPoolDomain =
      zio.aws.elasticloadbalancingv2.model.primitives
        .AuthenticateCognitoActionUserPoolDomain(impl.userPoolDomain())
    override val sessionCookieName
        : Option[AuthenticateCognitoActionSessionCookieName] = scala
      .Option(impl.sessionCookieName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .AuthenticateCognitoActionSessionCookieName(value)
      )
    override val scope: Option[AuthenticateCognitoActionScope] = scala
      .Option(impl.scope())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .AuthenticateCognitoActionScope(value)
      )
    override val sessionTimeout
        : Option[AuthenticateCognitoActionSessionTimeout] = scala
      .Option(impl.sessionTimeout())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .AuthenticateCognitoActionSessionTimeout(value)
      )
    override val authenticationRequestExtraParams: Option[Map[
      AuthenticateCognitoActionAuthenticationRequestParamName,
      AuthenticateCognitoActionAuthenticationRequestParamValue
    ]] = scala
      .Option(impl.authenticationRequestExtraParams())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateCognitoActionAuthenticationRequestParamName(
                key
              ) -> zio.aws.elasticloadbalancingv2.model.primitives
              .AuthenticateCognitoActionAuthenticationRequestParamValue(value)
          })
          .toMap
      )
    override val onUnauthenticatedRequest: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
    ] = scala
      .Option(impl.onUnauthenticatedRequest())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
  ): zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly =
    new Wrapper(impl)
}
