package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  LoadBalancerAttributeValue,
  LoadBalancerAttributeKey
}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerAttribute(
    key: Option[LoadBalancerAttributeKey] = None,
    value: Option[LoadBalancerAttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute = {
    import LoadBalancerAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute
      .builder()
      .optionallyWith(
        key.map(value =>
          LoadBalancerAttributeKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        value.map(value =>
          LoadBalancerAttributeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute
      .wrap(buildAwsValue())
}
object LoadBalancerAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute =
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[LoadBalancerAttributeKey]
    def value: Option[LoadBalancerAttributeValue]
    def getKey: ZIO[Any, AwsError, LoadBalancerAttributeKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, LoadBalancerAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute
  ) extends zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly {
    override val key: Option[LoadBalancerAttributeKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .LoadBalancerAttributeKey(value)
      )
    override val value: Option[LoadBalancerAttributeValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .LoadBalancerAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute.ReadOnly =
    new Wrapper(impl)
}
