package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ForwardActionConfig(
    targetGroups: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple]
    ] = None,
    targetGroupStickinessConfig: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig = {
    import ForwardActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(
        targetGroupStickinessConfig.map(value => value.buildAwsValue())
      )(_.targetGroupStickinessConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ForwardActionConfig
      .wrap(buildAwsValue())
}
object ForwardActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.ForwardActionConfig =
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetGroupStickinessConfig.map(value => value.asEditable)
      )
    def targetGroups: Option[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly]
    ]
    def targetGroupStickinessConfig: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getTargetGroupStickinessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetGroupStickinessConfig",
      targetGroupStickinessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly {
    override val targetGroups: Option[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.ReadOnly]
    ] = scala
      .Option(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroupTuple.wrap(item)
        }.toList
      )
    override val targetGroupStickinessConfig: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly
    ] = scala
      .Option(impl.targetGroupStickinessConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig
  ): zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly =
    new Wrapper(impl)
}
