package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  ActionOrder,
  TargetGroupArn
}
import scala.jdk.CollectionConverters.*
final case class Action(
    `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum,
    targetGroupArn: Option[TargetGroupArn] = None,
    authenticateOidcConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
    ] = None,
    authenticateCognitoConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
    ] = None,
    order: Option[ActionOrder] = None,
    redirectConfig: Option[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig
    ] = None,
    fixedResponseConfig: Option[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig
    ] = None,
    forwardConfig: Option[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        targetGroupArn.map(value =>
          TargetGroupArn.unwrap(value): java.lang.String
        )
      )(_.targetGroupArn)
      .optionallyWith(
        authenticateOidcConfig.map(value => value.buildAwsValue())
      )(_.authenticateOidcConfig)
      .optionallyWith(
        authenticateCognitoConfig.map(value => value.buildAwsValue())
      )(_.authenticateCognitoConfig)
      .optionallyWith(order.map(value => ActionOrder.unwrap(value): Integer))(
        _.order
      )
      .optionallyWith(redirectConfig.map(value => value.buildAwsValue()))(
        _.redirectConfig
      )
      .optionallyWith(fixedResponseConfig.map(value => value.buildAwsValue()))(
        _.fixedResponseConfig
      )
      .optionallyWith(forwardConfig.map(value => value.buildAwsValue()))(
        _.forwardConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Action.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Action =
      zio.aws.elasticloadbalancingv2.model.Action(
        `type`,
        targetGroupArn.map(value => value),
        authenticateOidcConfig.map(value => value.asEditable),
        authenticateCognitoConfig.map(value => value.asEditable),
        order.map(value => value),
        redirectConfig.map(value => value.asEditable),
        fixedResponseConfig.map(value => value.asEditable),
        forwardConfig.map(value => value.asEditable)
      )
    def `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum
    def targetGroupArn: Option[TargetGroupArn]
    def authenticateOidcConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ]
    def authenticateCognitoConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ]
    def order: Option[ActionOrder]
    def redirectConfig: Option[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ]
    def fixedResponseConfig: Option[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ]
    def forwardConfig: Option[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancingv2.model.ActionTypeEnum
    ] = ZIO.succeed(`type`)
    def getTargetGroupArn: ZIO[Any, AwsError, TargetGroupArn] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getAuthenticateOidcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticateOidcConfig",
      authenticateOidcConfig
    )
    def getAuthenticateCognitoConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticateCognitoConfig",
      authenticateCognitoConfig
    )
    def getOrder: ZIO[Any, AwsError, ActionOrder] =
      AwsError.unwrapOptionField("order", order)
    def getRedirectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("redirectConfig", redirectConfig)
    def getFixedResponseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("fixedResponseConfig", fixedResponseConfig)
    def getForwardConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("forwardConfig", forwardConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ) extends zio.aws.elasticloadbalancingv2.model.Action.ReadOnly {
    override val `type`: zio.aws.elasticloadbalancingv2.model.ActionTypeEnum =
      zio.aws.elasticloadbalancingv2.model.ActionTypeEnum.wrap(impl.`type`())
    override val targetGroupArn: Option[TargetGroupArn] = scala
      .Option(impl.targetGroupArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn(value)
      )
    override val authenticateOidcConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.ReadOnly
    ] = scala
      .Option(impl.authenticateOidcConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateOidcActionConfig
          .wrap(value)
      )
    override val authenticateCognitoConfig: Option[
      zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.ReadOnly
    ] = scala
      .Option(impl.authenticateCognitoConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig
          .wrap(value)
      )
    override val order: Option[ActionOrder] = scala
      .Option(impl.order())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ActionOrder(value)
      )
    override val redirectConfig: Option[
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly
    ] = scala
      .Option(impl.redirectConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.wrap(value)
      )
    override val fixedResponseConfig: Option[
      zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig.ReadOnly
    ] = scala
      .Option(impl.fixedResponseConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.FixedResponseActionConfig
          .wrap(value)
      )
    override val forwardConfig: Option[
      zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.ReadOnly
    ] = scala
      .Option(impl.forwardConfig())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ForwardActionConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Action
  ): zio.aws.elasticloadbalancingv2.model.Action.ReadOnly = new Wrapper(impl)
}
