package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  VpcId,
  HealthCheckThresholdCount,
  Port,
  HealthCheckTimeoutSeconds,
  ProtocolVersion,
  HealthCheckEnabled,
  HealthCheckIntervalSeconds,
  Path,
  TargetGroupName,
  HealthCheckPort
}
import scala.jdk.CollectionConverters.*
final case class CreateTargetGroupRequest(
    name: TargetGroupName,
    protocol: Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = None,
    protocolVersion: Option[ProtocolVersion] = None,
    port: Option[Port] = None,
    vpcId: Option[VpcId] = None,
    healthCheckProtocol: Option[
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = None,
    healthCheckPort: Option[HealthCheckPort] = None,
    healthCheckEnabled: Option[HealthCheckEnabled] = None,
    healthCheckPath: Option[Path] = None,
    healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds] = None,
    healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds] = None,
    healthyThresholdCount: Option[HealthCheckThresholdCount] = None,
    unhealthyThresholdCount: Option[HealthCheckThresholdCount] = None,
    matcher: Option[zio.aws.elasticloadbalancingv2.model.Matcher] = None,
    targetType: Option[zio.aws.elasticloadbalancingv2.model.TargetTypeEnum] =
      None,
    tags: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Tag]] = None,
    ipAddressType: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest = {
    import CreateTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
      .builder()
      .name(TargetGroupName.unwrap(name): java.lang.String)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        protocolVersion.map(value =>
          ProtocolVersion.unwrap(value): java.lang.String
        )
      )(_.protocolVersion)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(healthCheckProtocol.map(value => value.unwrap))(
        _.healthCheckProtocol
      )
      .optionallyWith(
        healthCheckPort.map(value =>
          HealthCheckPort.unwrap(value): java.lang.String
        )
      )(_.healthCheckPort)
      .optionallyWith(
        healthCheckEnabled.map(value =>
          HealthCheckEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.healthCheckEnabled)
      .optionallyWith(
        healthCheckPath.map(value => Path.unwrap(value): java.lang.String)
      )(_.healthCheckPath)
      .optionallyWith(
        healthCheckIntervalSeconds.map(value =>
          HealthCheckIntervalSeconds.unwrap(value): Integer
        )
      )(_.healthCheckIntervalSeconds)
      .optionallyWith(
        healthCheckTimeoutSeconds.map(value =>
          HealthCheckTimeoutSeconds.unwrap(value): Integer
        )
      )(_.healthCheckTimeoutSeconds)
      .optionallyWith(
        healthyThresholdCount.map(value =>
          HealthCheckThresholdCount.unwrap(value): Integer
        )
      )(_.healthyThresholdCount)
      .optionallyWith(
        unhealthyThresholdCount.map(value =>
          HealthCheckThresholdCount.unwrap(value): Integer
        )
      )(_.unhealthyThresholdCount)
      .optionallyWith(matcher.map(value => value.buildAwsValue()))(_.matcher)
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest
      .wrap(buildAwsValue())
}
object CreateTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest =
      zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest(
        name,
        protocol.map(value => value),
        protocolVersion.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        healthCheckProtocol.map(value => value),
        healthCheckPort.map(value => value),
        healthCheckEnabled.map(value => value),
        healthCheckPath.map(value => value),
        healthCheckIntervalSeconds.map(value => value),
        healthCheckTimeoutSeconds.map(value => value),
        healthyThresholdCount.map(value => value),
        unhealthyThresholdCount.map(value => value),
        matcher.map(value => value.asEditable),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value)
      )
    def name: TargetGroupName
    def protocol: Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def protocolVersion: Option[ProtocolVersion]
    def port: Option[Port]
    def vpcId: Option[VpcId]
    def healthCheckProtocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def healthCheckPort: Option[HealthCheckPort]
    def healthCheckEnabled: Option[HealthCheckEnabled]
    def healthCheckPath: Option[Path]
    def healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds]
    def healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds]
    def healthyThresholdCount: Option[HealthCheckThresholdCount]
    def unhealthyThresholdCount: Option[HealthCheckThresholdCount]
    def matcher: Option[zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly]
    def targetType: Option[zio.aws.elasticloadbalancingv2.model.TargetTypeEnum]
    def tags: Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]]
    def ipAddressType: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
    ]
    def getName: ZIO[Any, Nothing, TargetGroupName] = ZIO.succeed(name)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getProtocolVersion: ZIO[Any, AwsError, ProtocolVersion] =
      AwsError.unwrapOptionField("protocolVersion", protocolVersion)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getHealthCheckProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("healthCheckProtocol", healthCheckProtocol)
    def getHealthCheckPort: ZIO[Any, AwsError, HealthCheckPort] =
      AwsError.unwrapOptionField("healthCheckPort", healthCheckPort)
    def getHealthCheckEnabled: ZIO[Any, AwsError, HealthCheckEnabled] =
      AwsError.unwrapOptionField("healthCheckEnabled", healthCheckEnabled)
    def getHealthCheckPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getHealthCheckIntervalSeconds
        : ZIO[Any, AwsError, HealthCheckIntervalSeconds] =
      AwsError.unwrapOptionField(
        "healthCheckIntervalSeconds",
        healthCheckIntervalSeconds
      )
    def getHealthCheckTimeoutSeconds
        : ZIO[Any, AwsError, HealthCheckTimeoutSeconds] = AwsError
      .unwrapOptionField("healthCheckTimeoutSeconds", healthCheckTimeoutSeconds)
    def getHealthyThresholdCount
        : ZIO[Any, AwsError, HealthCheckThresholdCount] =
      AwsError.unwrapOptionField("healthyThresholdCount", healthyThresholdCount)
    def getUnhealthyThresholdCount
        : ZIO[Any, AwsError, HealthCheckThresholdCount] = AwsError
      .unwrapOptionField("unhealthyThresholdCount", unhealthyThresholdCount)
    def getMatcher: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly
    ] = AwsError.unwrapOptionField("matcher", matcher)
    def getTargetType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetTypeEnum
    ] = AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
  ) extends zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest.ReadOnly {
    override val name: TargetGroupName =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupName(impl.name())
    override val protocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = scala
      .Option(impl.protocol())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
      )
    override val protocolVersion: Option[ProtocolVersion] = scala
      .Option(impl.protocolVersion())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ProtocolVersion(value)
      )
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Port(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.VpcId(value)
      )
    override val healthCheckProtocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = scala
      .Option(impl.healthCheckProtocol())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
      )
    override val healthCheckPort: Option[HealthCheckPort] = scala
      .Option(impl.healthCheckPort())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckPort(value)
      )
    override val healthCheckEnabled: Option[HealthCheckEnabled] = scala
      .Option(impl.healthCheckEnabled())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .HealthCheckEnabled(value)
      )
    override val healthCheckPath: Option[Path] = scala
      .Option(impl.healthCheckPath())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Path(value))
    override val healthCheckIntervalSeconds
        : Option[HealthCheckIntervalSeconds] = scala
      .Option(impl.healthCheckIntervalSeconds())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .HealthCheckIntervalSeconds(value)
      )
    override val healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds] =
      scala
        .Option(impl.healthCheckTimeoutSeconds())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckTimeoutSeconds(value)
        )
    override val healthyThresholdCount: Option[HealthCheckThresholdCount] =
      scala
        .Option(impl.healthyThresholdCount())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckThresholdCount(value)
        )
    override val unhealthyThresholdCount: Option[HealthCheckThresholdCount] =
      scala
        .Option(impl.unhealthyThresholdCount())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckThresholdCount(value)
        )
    override val matcher
        : Option[zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly] = scala
      .Option(impl.matcher())
      .map(value => zio.aws.elasticloadbalancingv2.model.Matcher.wrap(value))
    override val targetType
        : Option[zio.aws.elasticloadbalancingv2.model.TargetTypeEnum] = scala
      .Option(impl.targetType())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.TargetTypeEnum.wrap(value)
      )
    override val tags
        : Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
          }.toList
        )
    override val ipAddressType: Option[
      zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
    ] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
  ): zio.aws.elasticloadbalancingv2.model.CreateTargetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
