package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  PageSize,
  Marker,
  SslPolicyName
}
import scala.jdk.CollectionConverters.*
final case class DescribeSslPoliciesRequest(
    names: Option[Iterable[SslPolicyName]] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None,
    loadBalancerType: Option[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest = {
    import DescribeSslPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            SslPolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(loadBalancerType.map(value => value.unwrap))(
        _.loadBalancerType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
      .wrap(buildAwsValue())
}
object DescribeSslPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest(
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value),
        loadBalancerType.map(value => value)
      )
    def names: Option[List[SslPolicyName]]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def loadBalancerType
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum]
    def getNames: ZIO[Any, AwsError, List[SslPolicyName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getLoadBalancerType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = AwsError.unwrapOptionField("loadBalancerType", loadBalancerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly {
    override val names: Option[List[SslPolicyName]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
    override val loadBalancerType
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      scala
        .Option(impl.loadBalancerType())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
