package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters.*
final case class DescribeListenerCertificatesResponse(
    certificates: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse = {
    import DescribeListenerCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
      .wrap(buildAwsValue())
}
object DescribeListenerCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def certificates: Option[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ]
    def nextMarker: Option[Marker]
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly {
    override val certificates: Option[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ] = scala
      .Option(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
