package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.{TagKey, ResourceArn}
import scala.jdk.CollectionConverters.*
final case class RemoveTagsRequest(
    resourceArns: Iterable[ResourceArn],
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest = {
    import RemoveTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest
      .builder()
      .resourceArns(resourceArns.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.RemoveTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RemoveTagsRequest.wrap(buildAwsValue())
}
object RemoveTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.RemoveTagsRequest =
      zio.aws.elasticloadbalancingv2.model
        .RemoveTagsRequest(resourceArns, tagKeys)
    def resourceArns: List[ResourceArn]
    def tagKeys: List[TagKey]
    def getResourceArns: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(resourceArns)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.RemoveTagsRequest.ReadOnly {
    override val resourceArns: List[ResourceArn] = impl
      .resourceArns()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn(item)
      }
      .toList
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest
  ): zio.aws.elasticloadbalancingv2.model.RemoveTagsRequest.ReadOnly =
    new Wrapper(impl)
}
