package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.RuleArn
import scala.jdk.CollectionConverters.*
final case class ModifyRuleRequest(
    ruleArn: RuleArn,
    conditions: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.RuleCondition]
    ] = None,
    actions: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Action]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest = {
    import ModifyRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest
      .builder()
      .ruleArn(RuleArn.unwrap(ruleArn): java.lang.String)
      .optionallyWith(
        conditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditions)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest.wrap(buildAwsValue())
}
object ModifyRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest =
      zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest(
        ruleArn,
        conditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ruleArn: RuleArn
    def conditions: Option[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ]
    def actions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]]
    def getRuleArn: ZIO[Any, Nothing, RuleArn] = ZIO.succeed(ruleArn)
    def getConditions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("conditions", conditions)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest.ReadOnly {
    override val ruleArn: RuleArn =
      zio.aws.elasticloadbalancingv2.model.primitives.RuleArn(impl.ruleArn())
    override val conditions: Option[
      List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    ] = scala
      .Option(impl.conditions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.RuleCondition.wrap(item)
        }.toList
      )
    override val actions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]] =
      scala
        .Option(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest
  ): zio.aws.elasticloadbalancingv2.model.ModifyRuleRequest.ReadOnly =
    new Wrapper(impl)
}
