package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Description
import scala.jdk.CollectionConverters.*
final case class TargetHealth(
    state: Option[zio.aws.elasticloadbalancingv2.model.TargetHealthStateEnum] =
      None,
    reason: Option[
      zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum
    ] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth = {
    import TargetHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(reason.map(value => value.unwrap))(_.reason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetHealth.wrap(buildAwsValue())
}
object TargetHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.TargetHealth =
      zio.aws.elasticloadbalancingv2.model.TargetHealth(
        state.map(value => value),
        reason.map(value => value),
        description.map(value => value)
      )
    def state
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealthStateEnum]
    def reason
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum]
    def description: Option[Description]
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetHealthStateEnum
    ] = AwsError.unwrapOptionField("state", state)
    def getReason: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum
    ] = AwsError.unwrapOptionField("reason", reason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth
  ) extends zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly {
    override val state
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealthStateEnum] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.TargetHealthStateEnum.wrap(value)
        )
    override val reason
        : Option[zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum] =
      scala
        .Option(impl.reason())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.TargetHealthReasonEnum
            .wrap(value)
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth
  ): zio.aws.elasticloadbalancingv2.model.TargetHealth.ReadOnly = new Wrapper(
    impl
  )
}
