package zio.aws.elasticloadbalancingv2.model
import scala.jdk.CollectionConverters.*
sealed trait TargetTypeEnum {
  def unwrap: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum
}
object TargetTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum
  ): zio.aws.elasticloadbalancingv2.model.TargetTypeEnum = value match {
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.INSTANCE =>
      val r = instance
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.IP =>
      val r = ip
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.LAMBDA =>
      val r = lambda
      r
    case software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.ALB =>
      val r = alb
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticloadbalancingv2.model.TargetTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object instance
      extends zio.aws.elasticloadbalancingv2.model.TargetTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.INSTANCE
  }
  case object ip extends zio.aws.elasticloadbalancingv2.model.TargetTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.IP
  }
  case object lambda
      extends zio.aws.elasticloadbalancingv2.model.TargetTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.LAMBDA
  }
  case object alb extends zio.aws.elasticloadbalancingv2.model.TargetTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum =
      software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum.ALB
  }
}
