package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  OutpostId,
  SubnetId,
  ZoneName
}
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(
    zoneName: Option[ZoneName] = None,
    subnetId: Option[SubnetId] = None,
    outpostId: Option[OutpostId] = None,
    loadBalancerAddresses: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone
      .builder()
      .optionallyWith(
        zoneName.map(value => ZoneName.unwrap(value): java.lang.String)
      )(_.zoneName)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        outpostId.map(value => OutpostId.unwrap(value): java.lang.String)
      )(_.outpostId)
      .optionallyWith(
        loadBalancerAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancerAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.AvailabilityZone =
      zio.aws.elasticloadbalancingv2.model.AvailabilityZone(
        zoneName.map(value => value),
        subnetId.map(value => value),
        outpostId.map(value => value),
        loadBalancerAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def zoneName: Option[ZoneName]
    def subnetId: Option[SubnetId]
    def outpostId: Option[OutpostId]
    def loadBalancerAddresses: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly]
    ]
    def getZoneName: ZIO[Any, AwsError, ZoneName] =
      AwsError.unwrapOptionField("zoneName", zoneName)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getOutpostId: ZIO[Any, AwsError, OutpostId] =
      AwsError.unwrapOptionField("outpostId", outpostId)
    def getLoadBalancerAddresses: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly
    ]] =
      AwsError.unwrapOptionField("loadBalancerAddresses", loadBalancerAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone
  ) extends zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly {
    override val zoneName: Option[ZoneName] = scala
      .Option(impl.zoneName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ZoneName(value)
      )
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.SubnetId(value)
      )
    override val outpostId: Option[OutpostId] = scala
      .Option(impl.outpostId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.OutpostId(value)
      )
    override val loadBalancerAddresses: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.ReadOnly]
    ] = scala
      .Option(impl.loadBalancerAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone
  ): zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly =
    new Wrapper(impl)
}
