package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticloadbalancingv2.model.primitives.{
  VpcId,
  LoadBalancerArn,
  DNSName,
  SecurityGroupId,
  LoadBalancerName,
  CustomerOwnedIpv4Pool,
  CanonicalHostedZoneId,
  CreatedTime
}
import scala.jdk.CollectionConverters.*
final case class LoadBalancer(
    loadBalancerArn: Option[LoadBalancerArn] = None,
    dnsName: Option[DNSName] = None,
    canonicalHostedZoneId: Option[CanonicalHostedZoneId] = None,
    createdTime: Option[CreatedTime] = None,
    loadBalancerName: Option[LoadBalancerName] = None,
    scheme: Option[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = None,
    vpcId: Option[VpcId] = None,
    state: Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerState] =
      None,
    `type`: Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      None,
    availabilityZones: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.AvailabilityZone]
    ] = None,
    securityGroups: Option[Iterable[SecurityGroupId]] = None,
    ipAddressType: Option[zio.aws.elasticloadbalancingv2.model.IpAddressType] =
      None,
    customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
      .builder()
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        canonicalHostedZoneId.map(value =>
          CanonicalHostedZoneId.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneId)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        loadBalancerName.map(value =>
          LoadBalancerName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(scheme.map(value => value.unwrap))(_.scheme)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CustomerOwnedIpv4Pool.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.LoadBalancer =
      zio.aws.elasticloadbalancingv2.model.LoadBalancer(
        loadBalancerArn.map(value => value),
        dnsName.map(value => value),
        canonicalHostedZoneId.map(value => value),
        createdTime.map(value => value),
        loadBalancerName.map(value => value),
        scheme.map(value => value),
        vpcId.map(value => value),
        state.map(value => value.asEditable),
        `type`.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroups.map(value => value),
        ipAddressType.map(value => value),
        customerOwnedIpv4Pool.map(value => value)
      )
    def loadBalancerArn: Option[LoadBalancerArn]
    def dnsName: Option[DNSName]
    def canonicalHostedZoneId: Option[CanonicalHostedZoneId]
    def createdTime: Option[CreatedTime]
    def loadBalancerName: Option[LoadBalancerName]
    def scheme
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum]
    def vpcId: Option[VpcId]
    def state: Option[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ]
    def `type`
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum]
    def availabilityZones: Option[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ]
    def securityGroups: Option[List[SecurityGroupId]]
    def ipAddressType
        : Option[zio.aws.elasticloadbalancingv2.model.IpAddressType]
    def customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool]
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getCanonicalHostedZoneId: ZIO[Any, AwsError, CanonicalHostedZoneId] =
      AwsError.unwrapOptionField("canonicalHostedZoneId", canonicalHostedZoneId)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLoadBalancerName: ZIO[Any, AwsError, LoadBalancerName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getScheme: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
    ] = AwsError.unwrapOptionField("scheme", scheme)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum
    ] = AwsError.unwrapOptionField("type", `type`)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getIpAddressType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CustomerOwnedIpv4Pool] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ) extends zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly {
    override val loadBalancerArn: Option[LoadBalancerArn] = scala
      .Option(impl.loadBalancerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
      )
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.DNSName(value)
      )
    override val canonicalHostedZoneId: Option[CanonicalHostedZoneId] = scala
      .Option(impl.canonicalHostedZoneId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .CanonicalHostedZoneId(value)
      )
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.CreatedTime(value)
      )
    override val loadBalancerName: Option[LoadBalancerName] = scala
      .Option(impl.loadBalancerName())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerName(value)
      )
    override val scheme
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum] =
      scala
        .Option(impl.scheme())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerSchemeEnum
            .wrap(value)
        )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.VpcId(value)
      )
    override val state: Option[
      zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly
    ] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.LoadBalancerState.wrap(value)
      )
    override val `type`
        : Option[zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum] =
      scala
        .Option(impl.`type`())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerTypeEnum.wrap(value)
        )
    override val availabilityZones: Option[
      List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone.ReadOnly]
    ] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.AvailabilityZone.wrap(item)
        }.toList
      )
    override val securityGroups: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val ipAddressType
        : Option[zio.aws.elasticloadbalancingv2.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.IpAddressType.wrap(value)
      )
    override val customerOwnedIpv4Pool: Option[CustomerOwnedIpv4Pool] = scala
      .Option(impl.customerOwnedIpv4Pool())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .CustomerOwnedIpv4Pool(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly = new Wrapper(
    impl
  )
}
