package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class TagDescription(
    resourceArn: Option[ResourceArn] = None,
    tags: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription = {
    import TagDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.TagDescription.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TagDescription.wrap(buildAwsValue())
}
object TagDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.TagDescription =
      zio.aws.elasticloadbalancingv2.model.TagDescription(
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Option[ResourceArn]
    def tags: Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription
  ) extends zio.aws.elasticloadbalancingv2.model.TagDescription.ReadOnly {
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn(value)
      )
    override val tags
        : Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription
  ): zio.aws.elasticloadbalancingv2.model.TagDescription.ReadOnly = new Wrapper(
    impl
  )
}
