package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  HealthCheckThresholdCount,
  HealthCheckTimeoutSeconds,
  HealthCheckEnabled,
  HealthCheckIntervalSeconds,
  TargetGroupArn,
  Path,
  HealthCheckPort
}
import scala.jdk.CollectionConverters.*
final case class ModifyTargetGroupRequest(
    targetGroupArn: TargetGroupArn,
    healthCheckProtocol: Option[
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = None,
    healthCheckPort: Option[HealthCheckPort] = None,
    healthCheckPath: Option[Path] = None,
    healthCheckEnabled: Option[HealthCheckEnabled] = None,
    healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds] = None,
    healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds] = None,
    healthyThresholdCount: Option[HealthCheckThresholdCount] = None,
    unhealthyThresholdCount: Option[HealthCheckThresholdCount] = None,
    matcher: Option[zio.aws.elasticloadbalancingv2.model.Matcher] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest = {
    import ModifyTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .optionallyWith(healthCheckProtocol.map(value => value.unwrap))(
        _.healthCheckProtocol
      )
      .optionallyWith(
        healthCheckPort.map(value =>
          HealthCheckPort.unwrap(value): java.lang.String
        )
      )(_.healthCheckPort)
      .optionallyWith(
        healthCheckPath.map(value => Path.unwrap(value): java.lang.String)
      )(_.healthCheckPath)
      .optionallyWith(
        healthCheckEnabled.map(value =>
          HealthCheckEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.healthCheckEnabled)
      .optionallyWith(
        healthCheckIntervalSeconds.map(value =>
          HealthCheckIntervalSeconds.unwrap(value): Integer
        )
      )(_.healthCheckIntervalSeconds)
      .optionallyWith(
        healthCheckTimeoutSeconds.map(value =>
          HealthCheckTimeoutSeconds.unwrap(value): Integer
        )
      )(_.healthCheckTimeoutSeconds)
      .optionallyWith(
        healthyThresholdCount.map(value =>
          HealthCheckThresholdCount.unwrap(value): Integer
        )
      )(_.healthyThresholdCount)
      .optionallyWith(
        unhealthyThresholdCount.map(value =>
          HealthCheckThresholdCount.unwrap(value): Integer
        )
      )(_.unhealthyThresholdCount)
      .optionallyWith(matcher.map(value => value.buildAwsValue()))(_.matcher)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest
      .wrap(buildAwsValue())
}
object ModifyTargetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest =
      zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest(
        targetGroupArn,
        healthCheckProtocol.map(value => value),
        healthCheckPort.map(value => value),
        healthCheckPath.map(value => value),
        healthCheckEnabled.map(value => value),
        healthCheckIntervalSeconds.map(value => value),
        healthCheckTimeoutSeconds.map(value => value),
        healthyThresholdCount.map(value => value),
        unhealthyThresholdCount.map(value => value),
        matcher.map(value => value.asEditable)
      )
    def targetGroupArn: TargetGroupArn
    def healthCheckProtocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def healthCheckPort: Option[HealthCheckPort]
    def healthCheckPath: Option[Path]
    def healthCheckEnabled: Option[HealthCheckEnabled]
    def healthCheckIntervalSeconds: Option[HealthCheckIntervalSeconds]
    def healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds]
    def healthyThresholdCount: Option[HealthCheckThresholdCount]
    def unhealthyThresholdCount: Option[HealthCheckThresholdCount]
    def matcher: Option[zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly]
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
    def getHealthCheckProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("healthCheckProtocol", healthCheckProtocol)
    def getHealthCheckPort: ZIO[Any, AwsError, HealthCheckPort] =
      AwsError.unwrapOptionField("healthCheckPort", healthCheckPort)
    def getHealthCheckPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getHealthCheckEnabled: ZIO[Any, AwsError, HealthCheckEnabled] =
      AwsError.unwrapOptionField("healthCheckEnabled", healthCheckEnabled)
    def getHealthCheckIntervalSeconds
        : ZIO[Any, AwsError, HealthCheckIntervalSeconds] =
      AwsError.unwrapOptionField(
        "healthCheckIntervalSeconds",
        healthCheckIntervalSeconds
      )
    def getHealthCheckTimeoutSeconds
        : ZIO[Any, AwsError, HealthCheckTimeoutSeconds] = AwsError
      .unwrapOptionField("healthCheckTimeoutSeconds", healthCheckTimeoutSeconds)
    def getHealthyThresholdCount
        : ZIO[Any, AwsError, HealthCheckThresholdCount] =
      AwsError.unwrapOptionField("healthyThresholdCount", healthyThresholdCount)
    def getUnhealthyThresholdCount
        : ZIO[Any, AwsError, HealthCheckThresholdCount] = AwsError
      .unwrapOptionField("unhealthyThresholdCount", unhealthyThresholdCount)
    def getMatcher: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly
    ] = AwsError.unwrapOptionField("matcher", matcher)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
    override val healthCheckProtocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = scala
      .Option(impl.healthCheckProtocol())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
      )
    override val healthCheckPort: Option[HealthCheckPort] = scala
      .Option(impl.healthCheckPort())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckPort(value)
      )
    override val healthCheckPath: Option[Path] = scala
      .Option(impl.healthCheckPath())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Path(value))
    override val healthCheckEnabled: Option[HealthCheckEnabled] = scala
      .Option(impl.healthCheckEnabled())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .HealthCheckEnabled(value)
      )
    override val healthCheckIntervalSeconds
        : Option[HealthCheckIntervalSeconds] = scala
      .Option(impl.healthCheckIntervalSeconds())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .HealthCheckIntervalSeconds(value)
      )
    override val healthCheckTimeoutSeconds: Option[HealthCheckTimeoutSeconds] =
      scala
        .Option(impl.healthCheckTimeoutSeconds())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckTimeoutSeconds(value)
        )
    override val healthyThresholdCount: Option[HealthCheckThresholdCount] =
      scala
        .Option(impl.healthyThresholdCount())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckThresholdCount(value)
        )
    override val unhealthyThresholdCount: Option[HealthCheckThresholdCount] =
      scala
        .Option(impl.unhealthyThresholdCount())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .HealthCheckThresholdCount(value)
        )
    override val matcher
        : Option[zio.aws.elasticloadbalancingv2.model.Matcher.ReadOnly] = scala
      .Option(impl.matcher())
      .map(value => zio.aws.elasticloadbalancingv2.model.Matcher.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
  ): zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
