package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn
import scala.jdk.CollectionConverters.*
final case class ModifyTargetGroupAttributesRequest(
    targetGroupArn: TargetGroupArn,
    attributes: Iterable[
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest = {
    import ModifyTargetGroupAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
      .builder()
      .targetGroupArn(TargetGroupArn.unwrap(targetGroupArn): java.lang.String)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
      .wrap(buildAwsValue())
}
object ModifyTargetGroupAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest =
      zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest(
        targetGroupArn,
        attributes.map { item =>
          item.asEditable
        }
      )
    def targetGroupArn: TargetGroupArn
    def attributes: List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly
    ]
    def getTargetGroupArn: ZIO[Any, Nothing, TargetGroupArn] =
      ZIO.succeed(targetGroupArn)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest.ReadOnly {
    override val targetGroupArn: TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .TargetGroupArn(impl.targetGroupArn())
    override val attributes: List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly
    ] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
  ): zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
