package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  LoadBalancerArn,
  Port,
  SslPolicyName,
  AlpnPolicyValue,
  ListenerArn
}
import scala.jdk.CollectionConverters.*
final case class Listener(
    listenerArn: Option[ListenerArn] = None,
    loadBalancerArn: Option[LoadBalancerArn] = None,
    port: Option[Port] = None,
    protocol: Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = None,
    certificates: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.Certificate]
    ] = None,
    sslPolicy: Option[SslPolicyName] = None,
    defaultActions: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.Action]
    ] = None,
    alpnPolicy: Option[Iterable[AlpnPolicyValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener
      .builder()
      .optionallyWith(
        listenerArn.map(value => ListenerArn.unwrap(value): java.lang.String)
      )(_.listenerArn)
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(
        sslPolicy.map(value => SslPolicyName.unwrap(value): java.lang.String)
      )(_.sslPolicy)
      .optionallyWith(
        defaultActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultActions)
      .optionallyWith(
        alpnPolicy.map(value =>
          value.map { item =>
            AlpnPolicyValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alpnPolicy)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Listener =
      zio.aws.elasticloadbalancingv2.model.Listener(
        listenerArn.map(value => value),
        loadBalancerArn.map(value => value),
        port.map(value => value),
        protocol.map(value => value),
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sslPolicy.map(value => value),
        defaultActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alpnPolicy.map(value => value)
      )
    def listenerArn: Option[ListenerArn]
    def loadBalancerArn: Option[LoadBalancerArn]
    def port: Option[Port]
    def protocol: Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum]
    def certificates: Option[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ]
    def sslPolicy: Option[SslPolicyName]
    def defaultActions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]]
    def alpnPolicy: Option[List[AlpnPolicyValue]]
    def getListenerArn: ZIO[Any, AwsError, ListenerArn] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ProtocolEnum
    ] = AwsError.unwrapOptionField("protocol", protocol)
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
    def getSslPolicy: ZIO[Any, AwsError, SslPolicyName] =
      AwsError.unwrapOptionField("sslPolicy", sslPolicy)
    def getDefaultActions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = AwsError.unwrapOptionField("defaultActions", defaultActions)
    def getAlpnPolicy: ZIO[Any, AwsError, List[AlpnPolicyValue]] =
      AwsError.unwrapOptionField("alpnPolicy", alpnPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener
  ) extends zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly {
    override val listenerArn: Option[ListenerArn] = scala
      .Option(impl.listenerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn(value)
      )
    override val loadBalancerArn: Option[LoadBalancerArn] = scala
      .Option(impl.loadBalancerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
      )
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Port(value))
    override val protocol
        : Option[zio.aws.elasticloadbalancingv2.model.ProtocolEnum] = scala
      .Option(impl.protocol())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.ProtocolEnum.wrap(value)
      )
    override val certificates: Option[
      List[zio.aws.elasticloadbalancingv2.model.Certificate.ReadOnly]
    ] = scala
      .Option(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.Certificate.wrap(item)
        }.toList
      )
    override val sslPolicy: Option[SslPolicyName] = scala
      .Option(impl.sslPolicy())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName(value)
      )
    override val defaultActions
        : Option[List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]] =
      scala
        .Option(impl.defaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
          }.toList
        )
    override val alpnPolicy: Option[List[AlpnPolicyValue]] = scala
      .Option(impl.alpnPolicy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.AlpnPolicyValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener
  ): zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly = new Wrapper(impl)
}
