package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SetRulePrioritiesResponse(
    rules: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Rule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse = {
    import SetRulePrioritiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse
      .wrap(buildAwsValue())
}
object SetRulePrioritiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse =
      zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Option[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly {
    override val rules
        : Option[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Rule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
  ): zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly =
    new Wrapper(impl)
}
