package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  TargetGroupStickinessDurationSeconds,
  TargetGroupStickinessEnabled
}
import scala.jdk.CollectionConverters.*
final case class TargetGroupStickinessConfig(
    enabled: Option[TargetGroupStickinessEnabled] = None,
    durationSeconds: Option[TargetGroupStickinessDurationSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig = {
    import TargetGroupStickinessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
      .builder()
      .optionallyWith(
        enabled.map(value =>
          TargetGroupStickinessEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .optionallyWith(
        durationSeconds.map(value =>
          TargetGroupStickinessDurationSeconds.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig
      .wrap(buildAwsValue())
}
object TargetGroupStickinessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig =
      zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig(
        enabled.map(value => value),
        durationSeconds.map(value => value)
      )
    def enabled: Option[TargetGroupStickinessEnabled]
    def durationSeconds: Option[TargetGroupStickinessDurationSeconds]
    def getEnabled: ZIO[Any, AwsError, TargetGroupStickinessEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDurationSeconds
        : ZIO[Any, AwsError, TargetGroupStickinessDurationSeconds] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ) extends zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly {
    override val enabled: Option[TargetGroupStickinessEnabled] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .TargetGroupStickinessEnabled(value)
      )
    override val durationSeconds: Option[TargetGroupStickinessDurationSeconds] =
      scala
        .Option(impl.durationSeconds())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .TargetGroupStickinessDurationSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig
  ): zio.aws.elasticloadbalancingv2.model.TargetGroupStickinessConfig.ReadOnly =
    new Wrapper(impl)
}
