package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyListenerResponse(
    listeners: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Listener]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse = {
    import ModifyListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse
      .wrap(buildAwsValue())
}
object ModifyListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse =
      zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse
  ) extends zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly {
    override val listeners
        : Option[List[zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly]] =
      scala
        .Option(impl.listeners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Listener.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse
  ): zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly =
    new Wrapper(impl)
}
