package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters.*
final case class DescribeLoadBalancersResponse(
    loadBalancers: Option[
      Iterable[zio.aws.elasticloadbalancingv2.model.LoadBalancer]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse = {
    import DescribeLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
      .builder()
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse(
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loadBalancers: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ]
    def nextMarker: Option[Marker]
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly {
    override val loadBalancers: Option[
      List[zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly]
    ] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly =
    new Wrapper(impl)
}
