package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  Marker,
  LoadBalancerArn,
  TargetGroupArn,
  PageSize,
  TargetGroupName
}
import scala.jdk.CollectionConverters.*
final case class DescribeTargetGroupsRequest(
    loadBalancerArn: Option[LoadBalancerArn] = None,
    targetGroupArns: Option[Iterable[TargetGroupArn]] = None,
    names: Option[Iterable[TargetGroupName]] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest = {
    import DescribeTargetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
      .builder()
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        targetGroupArns.map(value =>
          value.map { item =>
            TargetGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetGroupArns)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            TargetGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeTargetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest(
        loadBalancerArn.map(value => value),
        targetGroupArns.map(value => value),
        names.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerArn: Option[LoadBalancerArn]
    def targetGroupArns: Option[List[TargetGroupArn]]
    def names: Option[List[TargetGroupName]]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getTargetGroupArns: ZIO[Any, AwsError, List[TargetGroupArn]] =
      AwsError.unwrapOptionField("targetGroupArns", targetGroupArns)
    def getNames: ZIO[Any, AwsError, List[TargetGroupName]] =
      AwsError.unwrapOptionField("names", names)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly {
    override val loadBalancerArn: Option[LoadBalancerArn] = scala
      .Option(impl.loadBalancerArn())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn(value)
      )
    override val targetGroupArns: Option[List[TargetGroupArn]] = scala
      .Option(impl.targetGroupArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn(item)
        }.toList
      )
    override val names: Option[List[TargetGroupName]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupName(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
