package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{PageSize, Marker}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountLimitsRequest(
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest = {
    import DescribeAccountLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest =
      zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest(
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
  ): zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
