package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.StringValue
import scala.jdk.CollectionConverters.*
final case class QueryStringKeyValuePair(
    key: Option[StringValue] = None,
    value: Option[StringValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair = {
    import QueryStringKeyValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair
      .builder()
      .optionallyWith(
        key.map(value => StringValue.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => StringValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair
      .wrap(buildAwsValue())
}
object QueryStringKeyValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair =
      zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[StringValue]
    def value: Option[StringValue]
    def getKey: ZIO[Any, AwsError, StringValue] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, StringValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair
  ) extends zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly {
    override val key: Option[StringValue] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.StringValue(value)
      )
    override val value: Option[StringValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.StringValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.QueryStringKeyValuePair
  ): zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair.ReadOnly =
    new Wrapper(impl)
}
