package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  RulePriority,
  ListenerArn
}
import scala.jdk.CollectionConverters.*
final case class CreateRuleRequest(
    listenerArn: ListenerArn,
    conditions: Iterable[zio.aws.elasticloadbalancingv2.model.RuleCondition],
    priority: RulePriority,
    actions: Iterable[zio.aws.elasticloadbalancingv2.model.Action],
    tags: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest = {
    import CreateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest
      .builder()
      .listenerArn(ListenerArn.unwrap(listenerArn): java.lang.String)
      .conditions(conditions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .priority(RulePriority.unwrap(priority): Integer)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.CreateRuleRequest.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.CreateRuleRequest.wrap(buildAwsValue())
}
object CreateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.CreateRuleRequest =
      zio.aws.elasticloadbalancingv2.model.CreateRuleRequest(
        listenerArn,
        conditions.map { item =>
          item.asEditable
        },
        priority,
        actions.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listenerArn: ListenerArn
    def conditions
        : List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly]
    def priority: RulePriority
    def actions: List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly]
    def tags: Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]]
    def getListenerArn: ZIO[Any, Nothing, ListenerArn] =
      ZIO.succeed(listenerArn)
    def getConditions: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly
    ]] = ZIO.succeed(conditions)
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancingv2.model.Action.ReadOnly
    ]] = ZIO.succeed(actions)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest
  ) extends zio.aws.elasticloadbalancingv2.model.CreateRuleRequest.ReadOnly {
    override val listenerArn: ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives
        .ListenerArn(impl.listenerArn())
    override val conditions
        : List[zio.aws.elasticloadbalancingv2.model.RuleCondition.ReadOnly] =
      impl
        .conditions()
        .asScala
        .map { item =>
          zio.aws.elasticloadbalancingv2.model.RuleCondition.wrap(item)
        }
        .toList
    override val priority: RulePriority =
      zio.aws.elasticloadbalancingv2.model.primitives
        .RulePriority(impl.priority())
    override val actions
        : List[zio.aws.elasticloadbalancingv2.model.Action.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancingv2.model.Action.wrap(item)
      }
      .toList
    override val tags
        : Option[List[zio.aws.elasticloadbalancingv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest
  ): zio.aws.elasticloadbalancingv2.model.CreateRuleRequest.ReadOnly =
    new Wrapper(impl)
}
