package zio.aws.elasticloadbalancingv2
import zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.ReadOnly
import zio.aws.elasticloadbalancingv2.model.{
  ModifyListenerRequest,
  DescribeRulesRequest,
  DescribeListenerCertificatesRequest,
  SetRulePrioritiesRequest,
  ModifyTargetGroupAttributesRequest,
  RegisterTargetsRequest,
  DescribeSslPoliciesRequest,
  SetSubnetsRequest,
  SetIpAddressTypeRequest,
  DescribeTargetHealthRequest,
  RemoveListenerCertificatesRequest,
  DescribeLoadBalancerAttributesRequest,
  DescribeTargetGroupAttributesRequest,
  DeregisterTargetsRequest,
  AddTagsRequest,
  CreateRuleRequest,
  DescribeListenersRequest,
  SetSecurityGroupsRequest,
  AddListenerCertificatesRequest,
  DeleteRuleRequest,
  CreateLoadBalancerRequest,
  ModifyLoadBalancerAttributesRequest,
  DescribeTagsRequest,
  DeleteLoadBalancerRequest,
  DescribeTargetGroupsRequest,
  DescribeLoadBalancersRequest,
  CreateTargetGroupRequest,
  ModifyRuleRequest,
  DescribeAccountLimitsRequest,
  DeleteListenerRequest,
  CreateListenerRequest,
  ModifyTargetGroupRequest,
  DeleteTargetGroupRequest,
  RemoveTagsRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.elasticloadbalancingv2.model.{
  SetSubnetsResponse,
  ModifyTargetGroupResponse,
  ModifyRuleResponse,
  DescribeListenerCertificatesResponse,
  SetRulePrioritiesResponse,
  DescribeAccountLimitsResponse,
  DescribeLoadBalancersResponse,
  LoadBalancer,
  TargetGroup,
  SetIpAddressTypeResponse,
  DescribeListenersResponse,
  RemoveTagsResponse,
  CreateTargetGroupResponse,
  RemoveListenerCertificatesResponse,
  DeleteLoadBalancerResponse,
  DescribeTargetGroupAttributesResponse,
  DescribeTargetHealthResponse,
  Listener,
  ModifyTargetGroupAttributesResponse,
  SetSecurityGroupsResponse,
  CreateLoadBalancerResponse,
  AddTagsResponse,
  DescribeSslPoliciesResponse,
  RegisterTargetsResponse,
  DeleteListenerResponse,
  DeleteTargetGroupResponse,
  CreateListenerResponse,
  ModifyListenerResponse,
  CreateRuleResponse,
  DeregisterTargetsResponse,
  DescribeTagsResponse,
  ModifyLoadBalancerAttributesResponse,
  AddListenerCertificatesResponse,
  DescribeLoadBalancerAttributesResponse,
  DescribeRulesResponse,
  DeleteRuleResponse,
  DescribeTargetGroupsResponse
}
import software.amazon.awssdk.services.elasticloadbalancingv2.{
  ElasticLoadBalancingV2AsyncClientBuilder,
  ElasticLoadBalancingV2AsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.{
  DescribeLoadBalancersPublisher,
  DescribeListenersPublisher,
  DescribeTargetGroupsPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ElasticLoadBalancingV2 extends AspectSupport[ElasticLoadBalancingV2] {
  val api: ElasticLoadBalancingV2AsyncClient
  def addListenerCertificates(request: AddListenerCertificatesRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly
  ]
  def describeTags(request: DescribeTagsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.ReadOnly
  ]
  def deleteTargetGroup(request: DeleteTargetGroupRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.ReadOnly
  ]
  def describeLoadBalancerAttributes(
      request: DescribeLoadBalancerAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly
  ]
  def describeListenerCertificates(
      request: DescribeListenerCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly
  ]
  def deregisterTargets(request: DeregisterTargetsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.ReadOnly
  ]
  def describeTargetGroups(request: DescribeTargetGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
  ]
  def describeTargetGroupsPaginated(request: DescribeTargetGroupsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly
  ]
  def addTags(
      request: AddTagsRequest
  ): IO[AwsError, zio.aws.elasticloadbalancingv2.model.AddTagsResponse.ReadOnly]
  def setSecurityGroups(request: SetSecurityGroupsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly
  ]
  def deleteListener(request: DeleteListenerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.ReadOnly
  ]
  def describeAccountLimits(
      request: DescribeAccountLimitsRequest
  ): IO[AwsError, ReadOnly]
  def describeSSLPolicies(request: DescribeSslPoliciesRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly
  ]
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.ReadOnly
  ]
  def setRulePriorities(request: SetRulePrioritiesRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly
  ]
  def deleteRule(request: DeleteRuleRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.ReadOnly
  ]
  def registerTargets(request: RegisterTargetsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.ReadOnly
  ]
  def createTargetGroup(request: CreateTargetGroupRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly
  ]
  def removeTags(request: RemoveTagsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.ReadOnly
  ]
  def createListener(request: CreateListenerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly
  ]
  def modifyLoadBalancerAttributes(
      request: ModifyLoadBalancerAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly
  ]
  def describeTargetGroupAttributes(
      request: DescribeTargetGroupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly
  ]
  def describeListeners(request: DescribeListenersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
  ]
  def describeListenersPaginated(request: DescribeListenersRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly
  ]
  def modifyListener(request: ModifyListenerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly
  ]
  def modifyRule(request: ModifyRuleRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly
  ]
  def modifyTargetGroup(request: ModifyTargetGroupRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.ReadOnly
  ]
  def describeTargetHealth(request: DescribeTargetHealthRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly
  ]
  def modifyTargetGroupAttributes(
      request: ModifyTargetGroupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.ReadOnly
  ]
  def setIpAddressType(request: SetIpAddressTypeRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly
  ]
  def removeListenerCertificates(
      request: RemoveListenerCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.ReadOnly
  ]
  def describeRules(request: DescribeRulesRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly
  ]
  def setSubnets(request: SetSubnetsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly
  ]
  def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly
  ]
  def describeLoadBalancers(request: DescribeLoadBalancersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
  ]
  def describeLoadBalancersPaginated(request: DescribeLoadBalancersRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly
  ]
  def createRule(request: CreateRuleRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly
  ]
}
object ElasticLoadBalancingV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElasticLoadBalancingV2] =
    customized(identity)
  def customized(
      customization: ElasticLoadBalancingV2AsyncClientBuilder => ElasticLoadBalancingV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElasticLoadBalancingV2] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticLoadBalancingV2AsyncClientBuilder => ElasticLoadBalancingV2AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ElasticLoadBalancingV2] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticLoadBalancingV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ElasticLoadBalancingV2AsyncClient,
        ElasticLoadBalancingV2AsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticLoadBalancingV2AsyncClient,
        ElasticLoadBalancingV2AsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticLoadBalancingV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticLoadBalancingV2Impl[R](
      override val api: ElasticLoadBalancingV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElasticLoadBalancingV2
      with AwsServiceBase[R] {
    override val serviceName: String = "ElasticLoadBalancingV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticLoadBalancingV2Impl[R1] =
      new ElasticLoadBalancingV2Impl(api, newAspect, r)
    def addListenerCertificates(request: AddListenerCertificatesRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest,
      AddListenerCertificatesResponse
    ]("addListenerCertificates", api.addListenerCertificates)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.wrap
    ).provideEnvironment(r)
    def describeTags(request: DescribeTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest,
      DescribeTagsResponse
    ]("describeTags", api.describeTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.wrap)
      .provideEnvironment(r)
    def deleteTargetGroup(request: DeleteTargetGroupRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest,
      DeleteTargetGroupResponse
    ]("deleteTargetGroup", api.deleteTargetGroup)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def describeLoadBalancerAttributes(
        request: DescribeLoadBalancerAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest,
      DescribeLoadBalancerAttributesResponse
    ]("describeLoadBalancerAttributes", api.describeLoadBalancerAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.wrap
    ).provideEnvironment(r)
    def describeListenerCertificates(
        request: DescribeListenerCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest,
      DescribeListenerCertificatesResponse
    ]("describeListenerCertificates", api.describeListenerCertificates)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.wrap
    ).provideEnvironment(r)
    def deregisterTargets(request: DeregisterTargetsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest,
      DeregisterTargetsResponse
    ]("deregisterTargets", api.deregisterTargets)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.wrap)
      .provideEnvironment(r)
    def describeTargetGroups(request: DescribeTargetGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest,
      TargetGroup,
      DescribeTargetGroupsPublisher
    ](
      "describeTargetGroups",
      api.describeTargetGroupsPaginator,
      _.targetGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticloadbalancingv2.model.TargetGroup.wrap(item))
      .provideEnvironment(r)
    def describeTargetGroupsPaginated(request: DescribeTargetGroupsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest,
      DescribeTargetGroupsResponse
    ]("describeTargetGroups", api.describeTargetGroups)(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.wrap
      )
      .provideEnvironment(r)
    def addTags(request: AddTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.AddTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest,
      AddTagsResponse
    ]("addTags", api.addTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.AddTagsResponse.wrap)
      .provideEnvironment(r)
    def setSecurityGroups(request: SetSecurityGroupsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest,
      SetSecurityGroupsResponse
    ]("setSecurityGroups", api.setSecurityGroups)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def deleteListener(request: DeleteListenerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest,
      DeleteListenerResponse
    ]("deleteListener", api.deleteListener)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.wrap)
      .provideEnvironment(r)
    def describeAccountLimits(
        request: DescribeAccountLimitsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse
    ]("describeAccountLimits", api.describeAccountLimits)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.DescribeAccountLimitsResponse.wrap
    ).provideEnvironment(r)
    def describeSSLPolicies(request: DescribeSslPoliciesRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest,
      DescribeSslPoliciesResponse
    ]("describeSSLPolicies", api.describeSSLPolicies)(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest,
      DeleteLoadBalancerResponse
    ]("deleteLoadBalancer", api.deleteLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def setRulePriorities(request: SetRulePrioritiesRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest,
      SetRulePrioritiesResponse
    ]("setRulePriorities", api.setRulePriorities)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.wrap)
      .provideEnvironment(r)
    def deleteRule(request: DeleteRuleRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest,
      DeleteRuleResponse
    ]("deleteRule", api.deleteRule)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.wrap)
      .provideEnvironment(r)
    def registerTargets(request: RegisterTargetsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest,
      RegisterTargetsResponse
    ]("registerTargets", api.registerTargets)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.wrap)
      .provideEnvironment(r)
    def createTargetGroup(request: CreateTargetGroupRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest,
      CreateTargetGroupResponse
    ]("createTargetGroup", api.createTargetGroup)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def removeTags(request: RemoveTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest,
      RemoveTagsResponse
    ]("removeTags", api.removeTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.wrap)
      .provideEnvironment(r)
    def createListener(request: CreateListenerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest,
      CreateListenerResponse
    ]("createListener", api.createListener)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.wrap)
      .provideEnvironment(r)
    def modifyLoadBalancerAttributes(
        request: ModifyLoadBalancerAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest,
      ModifyLoadBalancerAttributesResponse
    ]("modifyLoadBalancerAttributes", api.modifyLoadBalancerAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.wrap
    ).provideEnvironment(r)
    def describeTargetGroupAttributes(
        request: DescribeTargetGroupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest,
      DescribeTargetGroupAttributesResponse
    ]("describeTargetGroupAttributes", api.describeTargetGroupAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.wrap
    ).provideEnvironment(r)
    def describeListeners(request: DescribeListenersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest,
      Listener,
      DescribeListenersPublisher
    ]("describeListeners", api.describeListenersPaginator, _.listeners())(
      request.buildAwsValue()
    ).map(item => zio.aws.elasticloadbalancingv2.model.Listener.wrap(item))
      .provideEnvironment(r)
    def describeListenersPaginated(request: DescribeListenersRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest,
      DescribeListenersResponse
    ]("describeListeners", api.describeListeners)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.wrap)
      .provideEnvironment(r)
    def modifyListener(request: ModifyListenerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest,
      ModifyListenerResponse
    ]("modifyListener", api.modifyListener)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.wrap)
      .provideEnvironment(r)
    def modifyRule(request: ModifyRuleRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest,
      ModifyRuleResponse
    ]("modifyRule", api.modifyRule)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.wrap)
      .provideEnvironment(r)
    def modifyTargetGroup(request: ModifyTargetGroupRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest,
      ModifyTargetGroupResponse
    ]("modifyTargetGroup", api.modifyTargetGroup)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def describeTargetHealth(request: DescribeTargetHealthRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest,
      DescribeTargetHealthResponse
    ]("describeTargetHealth", api.describeTargetHealth)(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.wrap
      )
      .provideEnvironment(r)
    def modifyTargetGroupAttributes(
        request: ModifyTargetGroupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest,
      ModifyTargetGroupAttributesResponse
    ]("modifyTargetGroupAttributes", api.modifyTargetGroupAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.wrap
    ).provideEnvironment(r)
    def setIpAddressType(request: SetIpAddressTypeRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest,
      SetIpAddressTypeResponse
    ]("setIpAddressType", api.setIpAddressType)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.wrap)
      .provideEnvironment(r)
    def removeListenerCertificates(
        request: RemoveListenerCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest,
      RemoveListenerCertificatesResponse
    ]("removeListenerCertificates", api.removeListenerCertificates)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.wrap
    ).provideEnvironment(r)
    def describeRules(request: DescribeRulesRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest,
      DescribeRulesResponse
    ]("describeRules", api.describeRules)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.wrap)
      .provideEnvironment(r)
    def setSubnets(request: SetSubnetsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest,
      SetSubnetsResponse
    ]("setSubnets", api.setSubnets)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.wrap)
      .provideEnvironment(r)
    def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest,
      CreateLoadBalancerResponse
    ]("createLoadBalancer", api.createLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def describeLoadBalancers(request: DescribeLoadBalancersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest,
      LoadBalancer,
      DescribeLoadBalancersPublisher
    ](
      "describeLoadBalancers",
      api.describeLoadBalancersPaginator,
      _.loadBalancers()
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticloadbalancingv2.model.LoadBalancer.wrap(item))
      .provideEnvironment(r)
    def describeLoadBalancersPaginated(
        request: DescribeLoadBalancersRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest,
      DescribeLoadBalancersResponse
    ]("describeLoadBalancers", api.describeLoadBalancers)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.wrap
    ).provideEnvironment(r)
    def createRule(request: CreateRuleRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest,
      CreateRuleResponse
    ]("createRule", api.createRule)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.wrap)
      .provideEnvironment(r)
  }
  def addListenerCertificates(request: AddListenerCertificatesRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.AddListenerCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addListenerCertificates(request))
  def describeTags(request: DescribeTagsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTags(request))
  def deleteTargetGroup(request: DeleteTargetGroupRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTargetGroup(request))
  def describeLoadBalancerAttributes(
      request: DescribeLoadBalancerAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancerAttributes(request))
  def describeListenerCertificates(
      request: DescribeListenerCertificatesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeListenerCertificates(request))
  def deregisterTargets(request: DeregisterTargetsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeregisterTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTargets(request))
  def describeTargetGroups(request: DescribeTargetGroupsRequest): ZStream[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.TargetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTargetGroups(request))
  def describeTargetGroupsPaginated(request: DescribeTargetGroupsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTargetGroupsPaginated(request))
  def addTags(request: AddTagsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def setSecurityGroups(request: SetSecurityGroupsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setSecurityGroups(request))
  def deleteListener(request: DeleteListenerRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteListener(request))
  def describeAccountLimits(request: DescribeAccountLimitsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountLimits(request))
  def describeSSLPolicies(request: DescribeSslPoliciesRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeSslPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSSLPolicies(request))
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancer(request))
  def setRulePriorities(request: SetRulePrioritiesRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetRulePrioritiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setRulePriorities(request))
  def deleteRule(request: DeleteRuleRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DeleteRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRule(request))
  def registerTargets(request: RegisterTargetsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RegisterTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTargets(request))
  def createTargetGroup(request: CreateTargetGroupRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTargetGroup(request))
  def removeTags(request: RemoveTagsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RemoveTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTags(request))
  def createListener(request: CreateListenerRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createListener(request))
  def modifyLoadBalancerAttributes(
      request: ModifyLoadBalancerAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyLoadBalancerAttributes(request))
  def describeTargetGroupAttributes(
      request: DescribeTargetGroupAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTargetGroupAttributes(request))
  def describeListeners(request: DescribeListenersRequest): ZStream[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.Listener.ReadOnly
  ] = ZStream.serviceWithStream(_.describeListeners(request))
  def describeListenersPaginated(request: DescribeListenersRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeListenersPaginated(request))
  def modifyListener(request: ModifyListenerRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyListener(request))
  def modifyRule(request: ModifyRuleRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyRule(request))
  def modifyTargetGroup(request: ModifyTargetGroupRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTargetGroup(request))
  def describeTargetHealth(request: DescribeTargetHealthRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeTargetHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTargetHealth(request))
  def modifyTargetGroupAttributes(
      request: ModifyTargetGroupAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTargetGroupAttributes(request))
  def setIpAddressType(request: SetIpAddressTypeRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetIpAddressTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIpAddressType(request))
  def removeListenerCertificates(
      request: RemoveListenerCertificatesRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeListenerCertificates(request))
  def describeRules(request: DescribeRulesRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRules(request))
  def setSubnets(request: SetSubnetsRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.SetSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setSubnets(request))
  def createLoadBalancer(request: CreateLoadBalancerRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancer(request))
  def describeLoadBalancers(request: DescribeLoadBalancersRequest): ZStream[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.LoadBalancer.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLoadBalancers(request))
  def describeLoadBalancersPaginated(
      request: DescribeLoadBalancersRequest
  ): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.DescribeLoadBalancersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancersPaginated(request))
  def createRule(request: CreateRuleRequest): ZIO[
    zio.aws.elasticloadbalancingv2.ElasticLoadBalancingV2,
    AwsError,
    zio.aws.elasticloadbalancingv2.model.CreateRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRule(request))
}
