package zio.aws.elasticloadbalancingv2.model
import zio.aws.elasticloadbalancingv2.model.primitives.{
  ZoneName,
  Port,
  TargetId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TargetDescription(
    id: TargetId,
    port: Optional[Port] = Optional.Absent,
    availabilityZone: Optional[ZoneName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription = {
    import TargetDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription
      .builder()
      .id(TargetId.unwrap(id): java.lang.String)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        availabilityZone.map(value => ZoneName.unwrap(value): java.lang.String)
      )(_.availabilityZone)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.TargetDescription.wrap(buildAwsValue())
}
object TargetDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.TargetDescription =
      zio.aws.elasticloadbalancingv2.model.TargetDescription(
        id,
        port.map(value => value),
        availabilityZone.map(value => value)
      )
    def id: TargetId
    def port: Optional[Port]
    def availabilityZone: Optional[ZoneName]
    def getId: ZIO[Any, Nothing, TargetId] = ZIO.succeed(id)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, ZoneName] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription
  ) extends zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly {
    override val id: TargetId =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetId(impl.id())
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.elasticloadbalancingv2.model.primitives.Port(value))
    override val availabilityZone: Optional[ZoneName] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.ZoneName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription
  ): zio.aws.elasticloadbalancingv2.model.TargetDescription.ReadOnly =
    new Wrapper(impl)
}
