package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.StateReason
import scala.jdk.CollectionConverters._
final case class LoadBalancerState(
    code: Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum] =
      Optional.Absent,
    reason: Optional[StateReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState = {
    import LoadBalancerState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        reason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.LoadBalancerState.wrap(buildAwsValue())
}
object LoadBalancerState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.LoadBalancerState =
      zio.aws.elasticloadbalancingv2.model
        .LoadBalancerState(code.map(value => value), reason.map(value => value))
    def code
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum]
    def reason: Optional[StateReason]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum
    ] = AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState
  ) extends zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly {
    override val code
        : Optional[zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.LoadBalancerStateEnum.wrap(value)
        )
    override val reason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.StateReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState
  ): zio.aws.elasticloadbalancingv2.model.LoadBalancerState.ReadOnly =
    new Wrapper(impl)
}
