package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTargetGroupAttributesResponse(
    attributes: Optional[
      Iterable[zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse = {
    import DescribeTargetGroupAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeTargetGroupAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse =
      zio.aws.elasticloadbalancingv2.model
        .DescribeTargetGroupAttributesResponse(
          attributes.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def attributes: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly {
    override val attributes: Optional[
      List[zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
