package zio.aws.elasticloadbalancingv2
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.elasticloadbalancingv2.model.primitives.{
  SubnetId,
  AuthenticateOidcActionAuthenticationRequestParamValue,
  LoadBalancerArn,
  AuthenticateCognitoActionAuthenticationRequestParamName,
  SslProtocol,
  RuleArn,
  AuthenticateOidcActionAuthenticationRequestParamName,
  SecurityGroupId,
  AuthenticateCognitoActionAuthenticationRequestParamValue,
  SslPolicyName,
  AlpnPolicyValue,
  ListenerArn,
  TargetGroupArn,
  LoadBalancerName,
  ResourceArn,
  TargetGroupName,
  StringValue,
  TagKey
}
import zio.aws.elasticloadbalancingv2.model.primitives.VpcId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActionOrder extends Subtype[Int]
    type ActionOrder =
      zio.aws.elasticloadbalancingv2.model.primitives.ActionOrder.Type
    object AllocationId extends Subtype[String]
    type AllocationId =
      zio.aws.elasticloadbalancingv2.model.primitives.AllocationId.Type
    object AlpnPolicyValue extends Subtype[String]
    type AlpnPolicyValue =
      zio.aws.elasticloadbalancingv2.model.primitives.AlpnPolicyValue.Type
    object AuthenticateCognitoActionAuthenticationRequestParamName
        extends Subtype[String]
    type AuthenticateCognitoActionAuthenticationRequestParamName =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionAuthenticationRequestParamName.Type
    object AuthenticateCognitoActionAuthenticationRequestParamValue
        extends Subtype[String]
    type AuthenticateCognitoActionAuthenticationRequestParamValue =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionAuthenticationRequestParamValue.Type
    object AuthenticateCognitoActionScope extends Subtype[String]
    type AuthenticateCognitoActionScope =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionScope.Type
    object AuthenticateCognitoActionSessionCookieName extends Subtype[String]
    type AuthenticateCognitoActionSessionCookieName =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionSessionCookieName.Type
    object AuthenticateCognitoActionSessionTimeout extends Subtype[Long]
    type AuthenticateCognitoActionSessionTimeout =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionSessionTimeout.Type
    object AuthenticateCognitoActionUserPoolArn extends Subtype[String]
    type AuthenticateCognitoActionUserPoolArn =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionUserPoolArn.Type
    object AuthenticateCognitoActionUserPoolClientId extends Subtype[String]
    type AuthenticateCognitoActionUserPoolClientId =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionUserPoolClientId.Type
    object AuthenticateCognitoActionUserPoolDomain extends Subtype[String]
    type AuthenticateCognitoActionUserPoolDomain =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateCognitoActionUserPoolDomain.Type
    object AuthenticateOidcActionAuthenticationRequestParamName
        extends Subtype[String]
    type AuthenticateOidcActionAuthenticationRequestParamName =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionAuthenticationRequestParamName.Type
    object AuthenticateOidcActionAuthenticationRequestParamValue
        extends Subtype[String]
    type AuthenticateOidcActionAuthenticationRequestParamValue =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionAuthenticationRequestParamValue.Type
    object AuthenticateOidcActionAuthorizationEndpoint extends Subtype[String]
    type AuthenticateOidcActionAuthorizationEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionAuthorizationEndpoint.Type
    object AuthenticateOidcActionClientId extends Subtype[String]
    type AuthenticateOidcActionClientId =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionClientId.Type
    object AuthenticateOidcActionClientSecret extends Subtype[String]
    type AuthenticateOidcActionClientSecret =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionClientSecret.Type
    object AuthenticateOidcActionIssuer extends Subtype[String]
    type AuthenticateOidcActionIssuer =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionIssuer.Type
    object AuthenticateOidcActionScope extends Subtype[String]
    type AuthenticateOidcActionScope =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionScope.Type
    object AuthenticateOidcActionSessionCookieName extends Subtype[String]
    type AuthenticateOidcActionSessionCookieName =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionSessionCookieName.Type
    object AuthenticateOidcActionSessionTimeout extends Subtype[Long]
    type AuthenticateOidcActionSessionTimeout =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionSessionTimeout.Type
    object AuthenticateOidcActionTokenEndpoint extends Subtype[String]
    type AuthenticateOidcActionTokenEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionTokenEndpoint.Type
    object AuthenticateOidcActionUseExistingClientSecret
        extends Subtype[Boolean]
    type AuthenticateOidcActionUseExistingClientSecret =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionUseExistingClientSecret.Type
    object AuthenticateOidcActionUserInfoEndpoint extends Subtype[String]
    type AuthenticateOidcActionUserInfoEndpoint =
      zio.aws.elasticloadbalancingv2.model.primitives.AuthenticateOidcActionUserInfoEndpoint.Type
    object CanonicalHostedZoneId extends Subtype[String]
    type CanonicalHostedZoneId =
      zio.aws.elasticloadbalancingv2.model.primitives.CanonicalHostedZoneId.Type
    object CertificateArn extends Subtype[String]
    type CertificateArn =
      zio.aws.elasticloadbalancingv2.model.primitives.CertificateArn.Type
    object CipherName extends Subtype[String]
    type CipherName =
      zio.aws.elasticloadbalancingv2.model.primitives.CipherName.Type
    object CipherPriority extends Subtype[Int]
    type CipherPriority =
      zio.aws.elasticloadbalancingv2.model.primitives.CipherPriority.Type
    object ConditionFieldName extends Subtype[String]
    type ConditionFieldName =
      zio.aws.elasticloadbalancingv2.model.primitives.ConditionFieldName.Type
    object CreatedTime extends Subtype[Instant]
    type CreatedTime =
      zio.aws.elasticloadbalancingv2.model.primitives.CreatedTime.Type
    object CustomerOwnedIpv4Pool extends Subtype[String]
    type CustomerOwnedIpv4Pool =
      zio.aws.elasticloadbalancingv2.model.primitives.CustomerOwnedIpv4Pool.Type
    object DNSName extends Subtype[String]
    type DNSName = zio.aws.elasticloadbalancingv2.model.primitives.DNSName.Type
    object Default extends Subtype[Boolean]
    type Default = zio.aws.elasticloadbalancingv2.model.primitives.Default.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.elasticloadbalancingv2.model.primitives.Description.Type
    object EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic
        extends Subtype[String]
    type EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic =
      zio.aws.elasticloadbalancingv2.model.primitives.EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic.Type
    object FixedResponseActionContentType extends Subtype[String]
    type FixedResponseActionContentType =
      zio.aws.elasticloadbalancingv2.model.primitives.FixedResponseActionContentType.Type
    object FixedResponseActionMessage extends Subtype[String]
    type FixedResponseActionMessage =
      zio.aws.elasticloadbalancingv2.model.primitives.FixedResponseActionMessage.Type
    object FixedResponseActionStatusCode extends Subtype[String]
    type FixedResponseActionStatusCode =
      zio.aws.elasticloadbalancingv2.model.primitives.FixedResponseActionStatusCode.Type
    object GrpcCode extends Subtype[String]
    type GrpcCode =
      zio.aws.elasticloadbalancingv2.model.primitives.GrpcCode.Type
    object HealthCheckEnabled extends Subtype[Boolean]
    type HealthCheckEnabled =
      zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckEnabled.Type
    object HealthCheckIntervalSeconds extends Subtype[Int]
    type HealthCheckIntervalSeconds =
      zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckIntervalSeconds.Type
    object HealthCheckPort extends Subtype[String]
    type HealthCheckPort =
      zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckPort.Type
    object HealthCheckThresholdCount extends Subtype[Int]
    type HealthCheckThresholdCount =
      zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckThresholdCount.Type
    object HealthCheckTimeoutSeconds extends Subtype[Int]
    type HealthCheckTimeoutSeconds =
      zio.aws.elasticloadbalancingv2.model.primitives.HealthCheckTimeoutSeconds.Type
    object HttpCode extends Subtype[String]
    type HttpCode =
      zio.aws.elasticloadbalancingv2.model.primitives.HttpCode.Type
    object HttpHeaderConditionName extends Subtype[String]
    type HttpHeaderConditionName =
      zio.aws.elasticloadbalancingv2.model.primitives.HttpHeaderConditionName.Type
    object IPv6Address extends Subtype[String]
    type IPv6Address =
      zio.aws.elasticloadbalancingv2.model.primitives.IPv6Address.Type
    object IpAddress extends Subtype[String]
    type IpAddress =
      zio.aws.elasticloadbalancingv2.model.primitives.IpAddress.Type
    object IsDefault extends Subtype[Boolean]
    type IsDefault =
      zio.aws.elasticloadbalancingv2.model.primitives.IsDefault.Type
    object ListenerArn extends Subtype[String]
    type ListenerArn =
      zio.aws.elasticloadbalancingv2.model.primitives.ListenerArn.Type
    object LoadBalancerArn extends Subtype[String]
    type LoadBalancerArn =
      zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerArn.Type
    object LoadBalancerAttributeKey extends Subtype[String]
    type LoadBalancerAttributeKey =
      zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerAttributeKey.Type
    object LoadBalancerAttributeValue extends Subtype[String]
    type LoadBalancerAttributeValue =
      zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerAttributeValue.Type
    object LoadBalancerName extends Subtype[String]
    type LoadBalancerName =
      zio.aws.elasticloadbalancingv2.model.primitives.LoadBalancerName.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.elasticloadbalancingv2.model.primitives.Marker.Type
    object Max extends Subtype[String]
    type Max = zio.aws.elasticloadbalancingv2.model.primitives.Max.Type
    object Name extends Subtype[String]
    type Name = zio.aws.elasticloadbalancingv2.model.primitives.Name.Type
    object OutpostId extends Subtype[String]
    type OutpostId =
      zio.aws.elasticloadbalancingv2.model.primitives.OutpostId.Type
    object PageSize extends Subtype[Int]
    type PageSize =
      zio.aws.elasticloadbalancingv2.model.primitives.PageSize.Type
    object Path extends Subtype[String]
    type Path = zio.aws.elasticloadbalancingv2.model.primitives.Path.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.elasticloadbalancingv2.model.primitives.Port.Type
    object PrivateIPv4Address extends Subtype[String]
    type PrivateIPv4Address =
      zio.aws.elasticloadbalancingv2.model.primitives.PrivateIPv4Address.Type
    object ProtocolVersion extends Subtype[String]
    type ProtocolVersion =
      zio.aws.elasticloadbalancingv2.model.primitives.ProtocolVersion.Type
    object RedirectActionHost extends Subtype[String]
    type RedirectActionHost =
      zio.aws.elasticloadbalancingv2.model.primitives.RedirectActionHost.Type
    object RedirectActionPath extends Subtype[String]
    type RedirectActionPath =
      zio.aws.elasticloadbalancingv2.model.primitives.RedirectActionPath.Type
    object RedirectActionPort extends Subtype[String]
    type RedirectActionPort =
      zio.aws.elasticloadbalancingv2.model.primitives.RedirectActionPort.Type
    object RedirectActionProtocol extends Subtype[String]
    type RedirectActionProtocol =
      zio.aws.elasticloadbalancingv2.model.primitives.RedirectActionProtocol.Type
    object RedirectActionQuery extends Subtype[String]
    type RedirectActionQuery =
      zio.aws.elasticloadbalancingv2.model.primitives.RedirectActionQuery.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.elasticloadbalancingv2.model.primitives.ResourceArn.Type
    object RuleArn extends Subtype[String]
    type RuleArn = zio.aws.elasticloadbalancingv2.model.primitives.RuleArn.Type
    object RulePriority extends Subtype[Int]
    type RulePriority =
      zio.aws.elasticloadbalancingv2.model.primitives.RulePriority.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.elasticloadbalancingv2.model.primitives.SecurityGroupId.Type
    object SslPolicyName extends Subtype[String]
    type SslPolicyName =
      zio.aws.elasticloadbalancingv2.model.primitives.SslPolicyName.Type
    object SslProtocol extends Subtype[String]
    type SslProtocol =
      zio.aws.elasticloadbalancingv2.model.primitives.SslProtocol.Type
    object StateReason extends Subtype[String]
    type StateReason =
      zio.aws.elasticloadbalancingv2.model.primitives.StateReason.Type
    object StringValue extends Subtype[String]
    type StringValue =
      zio.aws.elasticloadbalancingv2.model.primitives.StringValue.Type
    object SubnetId extends Subtype[String]
    type SubnetId =
      zio.aws.elasticloadbalancingv2.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.elasticloadbalancingv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue =
      zio.aws.elasticloadbalancingv2.model.primitives.TagValue.Type
    object TargetGroupArn extends Subtype[String]
    type TargetGroupArn =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupArn.Type
    object TargetGroupAttributeKey extends Subtype[String]
    type TargetGroupAttributeKey =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupAttributeKey.Type
    object TargetGroupAttributeValue extends Subtype[String]
    type TargetGroupAttributeValue =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupAttributeValue.Type
    object TargetGroupName extends Subtype[String]
    type TargetGroupName =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupName.Type
    object TargetGroupStickinessDurationSeconds extends Subtype[Int]
    type TargetGroupStickinessDurationSeconds =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupStickinessDurationSeconds.Type
    object TargetGroupStickinessEnabled extends Subtype[Boolean]
    type TargetGroupStickinessEnabled =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupStickinessEnabled.Type
    object TargetGroupWeight extends Subtype[Int]
    type TargetGroupWeight =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetGroupWeight.Type
    object TargetId extends Subtype[String]
    type TargetId =
      zio.aws.elasticloadbalancingv2.model.primitives.TargetId.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.elasticloadbalancingv2.model.primitives.VpcId.Type
    object ZoneName extends Subtype[String]
    type ZoneName =
      zio.aws.elasticloadbalancingv2.model.primitives.ZoneName.Type
  }
  type Actions = List[zio.aws.elasticloadbalancingv2.model.Action]
  type AlpnPolicyName = List[AlpnPolicyValue]
  type AuthenticateCognitoActionAuthenticationRequestExtraParams = Map[
    AuthenticateCognitoActionAuthenticationRequestParamName,
    AuthenticateCognitoActionAuthenticationRequestParamValue
  ]
  type AuthenticateOidcActionAuthenticationRequestExtraParams = Map[
    AuthenticateOidcActionAuthenticationRequestParamName,
    AuthenticateOidcActionAuthenticationRequestParamValue
  ]
  type AvailabilityZones =
    List[zio.aws.elasticloadbalancingv2.model.AvailabilityZone]
  type CertificateList = List[zio.aws.elasticloadbalancingv2.model.Certificate]
  type Ciphers = List[zio.aws.elasticloadbalancingv2.model.Cipher]
  type Limits = List[zio.aws.elasticloadbalancingv2.model.Limit]
  type ListOfString = List[StringValue]
  type ListenerArns = List[ListenerArn]
  type Listeners = List[zio.aws.elasticloadbalancingv2.model.Listener]
  type LoadBalancerAddresses =
    List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAddress]
  type LoadBalancerArns = List[LoadBalancerArn]
  type LoadBalancerAttributes =
    List[zio.aws.elasticloadbalancingv2.model.LoadBalancerAttribute]
  type LoadBalancerNames = List[LoadBalancerName]
  type LoadBalancers = List[zio.aws.elasticloadbalancingv2.model.LoadBalancer]
  type QueryStringKeyValuePairList =
    List[zio.aws.elasticloadbalancingv2.model.QueryStringKeyValuePair]
  type ResourceArns = List[ResourceArn]
  type RuleArns = List[RuleArn]
  type RuleConditionList =
    List[zio.aws.elasticloadbalancingv2.model.RuleCondition]
  type RulePriorityList =
    List[zio.aws.elasticloadbalancingv2.model.RulePriorityPair]
  type Rules = List[zio.aws.elasticloadbalancingv2.model.Rule]
  type SecurityGroups = List[SecurityGroupId]
  type SslPolicies = List[zio.aws.elasticloadbalancingv2.model.SslPolicy]
  type SslPolicyNames = List[SslPolicyName]
  type SslProtocols = List[SslProtocol]
  type SubnetMappings = List[zio.aws.elasticloadbalancingv2.model.SubnetMapping]
  type Subnets = List[SubnetId]
  type TagDescriptions =
    List[zio.aws.elasticloadbalancingv2.model.TagDescription]
  type TagKeys = List[TagKey]
  type TagList = List[zio.aws.elasticloadbalancingv2.model.Tag]
  type TargetDescriptions =
    List[zio.aws.elasticloadbalancingv2.model.TargetDescription]
  type TargetGroupArns = List[TargetGroupArn]
  type TargetGroupAttributes =
    List[zio.aws.elasticloadbalancingv2.model.TargetGroupAttribute]
  type TargetGroupList =
    List[zio.aws.elasticloadbalancingv2.model.TargetGroupTuple]
  type TargetGroupNames = List[TargetGroupName]
  type TargetGroups = List[zio.aws.elasticloadbalancingv2.model.TargetGroup]
  type TargetHealthDescriptions =
    List[zio.aws.elasticloadbalancingv2.model.TargetHealthDescription]
}
