package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticloadbalancingv2.model.primitives.{
  RedirectActionPath,
  RedirectActionProtocol,
  RedirectActionQuery,
  RedirectActionHost,
  RedirectActionPort
}
import scala.jdk.CollectionConverters._
final case class RedirectActionConfig(
    protocol: Optional[RedirectActionProtocol] = Optional.Absent,
    port: Optional[RedirectActionPort] = Optional.Absent,
    host: Optional[RedirectActionHost] = Optional.Absent,
    path: Optional[RedirectActionPath] = Optional.Absent,
    query: Optional[RedirectActionQuery] = Optional.Absent,
    statusCode: zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig = {
    import RedirectActionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig
      .builder()
      .optionallyWith(
        protocol.map(value =>
          RedirectActionProtocol.unwrap(value): java.lang.String
        )
      )(_.protocol)
      .optionallyWith(
        port.map(value => RedirectActionPort.unwrap(value): java.lang.String)
      )(_.port)
      .optionallyWith(
        host.map(value => RedirectActionHost.unwrap(value): java.lang.String)
      )(_.host)
      .optionallyWith(
        path.map(value => RedirectActionPath.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        query.map(value => RedirectActionQuery.unwrap(value): java.lang.String)
      )(_.query)
      .statusCode(statusCode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.RedirectActionConfig
      .wrap(buildAwsValue())
}
object RedirectActionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.RedirectActionConfig =
      zio.aws.elasticloadbalancingv2.model.RedirectActionConfig(
        protocol.map(value => value),
        port.map(value => value),
        host.map(value => value),
        path.map(value => value),
        query.map(value => value),
        statusCode
      )
    def protocol: Optional[RedirectActionProtocol]
    def port: Optional[RedirectActionPort]
    def host: Optional[RedirectActionHost]
    def path: Optional[RedirectActionPath]
    def query: Optional[RedirectActionQuery]
    def statusCode
        : zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
    def getProtocol: ZIO[Any, AwsError, RedirectActionProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, RedirectActionPort] =
      AwsError.unwrapOptionField("port", port)
    def getHost: ZIO[Any, AwsError, RedirectActionHost] =
      AwsError.unwrapOptionField("host", host)
    def getPath: ZIO[Any, AwsError, RedirectActionPath] =
      AwsError.unwrapOptionField("path", path)
    def getQuery: ZIO[Any, AwsError, RedirectActionQuery] =
      AwsError.unwrapOptionField("query", query)
    def getStatusCode: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
    ] = ZIO.succeed(statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig
  ) extends zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly {
    override val protocol: Optional[RedirectActionProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.elasticloadbalancingv2.model.primitives
            .RedirectActionProtocol(value)
        )
    override val port: Optional[RedirectActionPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .RedirectActionPort(value)
      )
    override val host: Optional[RedirectActionHost] = zio.aws.core.internal
      .optionalFromNullable(impl.host())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .RedirectActionHost(value)
      )
    override val path: Optional[RedirectActionPath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .RedirectActionPath(value)
      )
    override val query: Optional[RedirectActionQuery] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives
          .RedirectActionQuery(value)
      )
    override val statusCode
        : zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum =
      zio.aws.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum
        .wrap(impl.statusCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig
  ): zio.aws.elasticloadbalancingv2.model.RedirectActionConfig.ReadOnly =
    new Wrapper(impl)
}
